/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.frycooks_delight.core.registry;

import com.uraneptus.frycooks_delight.common.blocks.CanolaOilCauldronBlock;
import com.uraneptus.frycooks_delight.common.blocks.CanolaPlantBlock;
import com.uraneptus.frycooks_delight.common.blocks.HotGreaseFluidBlock;
import com.uraneptus.frycooks_delight.core.other.FCDProperties;
import com.uraneptus.frycooks_delight.core.registry.FCDFluids;
import com.uraneptus.frycooks_delight.core.registry.FCDItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.block.WildCropBlock;

@Mod.EventBusSubscriber(modid="frycooks_delight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FCDBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"frycooks_delight");
    public static final RegistryObject<Block> CANOLA_CRATE = FCDBlocks.registerWithBlockItem("canola_crate", () -> new Block(FCDProperties.CRATE));
    public static final RegistryObject<Block> CANOLA_PLANT = FCDBlocks.registerWithoutItem("canola_plant", () -> new CanolaPlantBlock(FCDProperties.CANOLA_PLANT));
    public static final RegistryObject<Block> WILD_CANOLA = FCDBlocks.registerWithBlockItem("wild_canola", () -> new WildCropBlock(MobEffects.f_19596_, 6, FCDProperties.WILD_CANOLA));
    public static final RegistryObject<LiquidBlock> HOT_GREASE = FCDBlocks.registerWithoutItem("hot_grease", () -> new HotGreaseFluidBlock((Supplier<? extends FlowingFluid>)FCDFluids.HOT_GREASE_SOURCE, FCDProperties.HOT_GREASE));
    public static final RegistryObject<Block> CANOLA_OIL_CAULDRON = FCDBlocks.registerWithBlockItem("canola_oil_cauldron", () -> new CanolaOilCauldronBlock(FCDProperties.CANOLA_OIL_CAULDRON));
    public static final RegistryObject<Block> LARD_BLOCK = FCDBlocks.registerWithBlockItem("lard_block", () -> new Block(FCDProperties.LARD_BLOCK){

        public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
        }
    });

    public static <T extends Block> RegistryObject<T> registerWithBlockItem(String name, Supplier<T> blockSupplier) {
        RegistryObject blockObj = BLOCKS.register(name, blockSupplier);
        FCDItems.ITEMS.register(name, () -> new BlockItem((Block)blockObj.get(), new Item.Properties()));
        return blockObj;
    }

    public static <T extends Block> RegistryObject<T> registerWithoutItem(String name, Supplier<T> blockSupplier) {
        return BLOCKS.register(name, blockSupplier);
    }
}

