/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.frycooks_delight.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.uraneptus.frycooks_delight.core.registry.FCDRecipes;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FryingRecipe
implements Recipe<Container> {
    public static final String NAME = "frying";
    private final ResourceLocation id;
    private final String recipeGroup;
    private final NonNullList<Ingredient> ingredients;
    private final NonNullList<ItemStack> results;

    public FryingRecipe(ResourceLocation id, String recipeGroup, NonNullList<Ingredient> pIngredients, NonNullList<ItemStack> results) {
        this.id = id;
        this.recipeGroup = recipeGroup;
        this.ingredients = pIngredients;
        this.results = results;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return true;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return (ItemStack)this.results.get(0);
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return (ItemStack)this.results.get(0);
    }

    public List<ItemStack> getResults() {
        return this.results;
    }

    public String m_6076_() {
        return this.recipeGroup;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static List<FryingRecipe> getRecipes(Level level) {
        return level.m_7465_().m_44013_((RecipeType)FCDRecipes.FRYING.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FCDRecipes.FRYING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FCDRecipes.FRYING.get();
    }

    public static class Serializer
    implements RecipeSerializer<FryingRecipe> {
        public FryingRecipe fromJson(ResourceLocation pRecipeId, JsonObject jsonObject) {
            String group = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for polishing recipe");
            }
            if (!jsonObject.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            NonNullList<ItemStack> results = Serializer.readResults(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"result"));
            return new FryingRecipe(pRecipeId, group, nonnulllist, results);
        }

        private static NonNullList<ItemStack> readResults(JsonArray resultArray) {
            NonNullList results = NonNullList.m_122779_();
            for (JsonElement element : resultArray) {
                JsonObject json = element.getAsJsonObject();
                if (json.get("item").isJsonObject()) {
                    results.add((Object)ShapedRecipe.m_151274_((JsonObject)json));
                    continue;
                }
                String resultItem = GsonHelper.m_13906_((JsonObject)json, (String)"item");
                int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
                results.add((Object)new ItemStack((Holder)ForgeRegistries.ITEMS.getDelegate(new ResourceLocation(resultItem)).orElseThrow(() -> new IllegalStateException("Item: " + resultItem + " does not exist")), count));
            }
            return results;
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray pIngredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            int ingredientSize = pIngredientArray.size();
            for (int i = 0; i < ingredientSize; ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)pIngredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public FryingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String group = pBuffer.m_130277_();
            int ingredientsAmount = pBuffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)ingredientsAmount, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredientsAmount; ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            int resultsAmount = pBuffer.m_130242_();
            NonNullList results = NonNullList.m_122780_((int)resultsAmount, (Object)ItemStack.f_41583_);
            for (int j = 0; j < resultsAmount; ++j) {
                results.set(j, (Object)pBuffer.m_130267_());
            }
            return new FryingRecipe(pRecipeId, group, (NonNullList<Ingredient>)nonnulllist, (NonNullList<ItemStack>)results);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, FryingRecipe pRecipe) {
            pBuffer.m_130070_(pRecipe.recipeGroup);
            pBuffer.m_130130_(pRecipe.ingredients.size());
            for (Ingredient ingredient : pRecipe.ingredients) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.m_130130_(pRecipe.results.size());
            for (ItemStack itemStack : pRecipe.results) {
                pBuffer.m_130055_(itemStack);
            }
        }
    }
}

