/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.frycooks_delight;

import com.uraneptus.frycooks_delight.core.other.FCDCriteriaTriggers;
import com.uraneptus.frycooks_delight.core.other.FCDTextUtil;
import com.uraneptus.frycooks_delight.core.registry.FCDBlocks;
import com.uraneptus.frycooks_delight.core.registry.FCDCreativeTabs;
import com.uraneptus.frycooks_delight.core.registry.FCDFluids;
import com.uraneptus.frycooks_delight.core.registry.FCDItems;
import com.uraneptus.frycooks_delight.core.registry.FCDMobEffects;
import com.uraneptus.frycooks_delight.core.registry.FCDParticleTypes;
import com.uraneptus.frycooks_delight.core.registry.FCDRecipes;
import com.uraneptus.frycooks_delight.data.client.FCDBlockStateProvider;
import com.uraneptus.frycooks_delight.data.client.FCDItemModelProvider;
import com.uraneptus.frycooks_delight.data.client.FCDLangProvider;
import com.uraneptus.frycooks_delight.data.client.FCDSoundDefinitionsProvider;
import com.uraneptus.frycooks_delight.data.server.FCDDatapackBuiltinEntriesProvider;
import com.uraneptus.frycooks_delight.data.server.advancements.FCDAdvancementProvider;
import com.uraneptus.frycooks_delight.data.server.advancements.FCDFDAdvancements;
import com.uraneptus.frycooks_delight.data.server.loot.FCDLootTableProvider;
import com.uraneptus.frycooks_delight.data.server.recipe.FCDRecipeProvider;
import com.uraneptus.frycooks_delight.data.server.tags.FCDBiomeTagsProvider;
import com.uraneptus.frycooks_delight.data.server.tags.FCDBlockTagsProvider;
import com.uraneptus.frycooks_delight.data.server.tags.FCDEntityTypeTagsProvider;
import com.uraneptus.frycooks_delight.data.server.tags.FCDFluidTagsProvider;
import com.uraneptus.frycooks_delight.data.server.tags.FCDItemTagsProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="frycooks_delight")
@Mod.EventBusSubscriber(modid="frycooks_delight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FrycooksDelight {
    public static final String MOD_ID = "frycooks_delight";

    public FrycooksDelight() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::gatherData);
        FCDTextUtil.init();
        FCDCriteriaTriggers.init();
        FCDFDAdvancements.initAdvancementTranslations();
        FCDBlocks.BLOCKS.register(bus);
        FCDItems.ITEMS.register(bus);
        FCDFluids.FLUID_TYPES.register(bus);
        FCDFluids.FLUIDS.register(bus);
        FCDCreativeTabs.TABS.register(bus);
        FCDRecipes.RECIPE_TYPES.register(bus);
        FCDRecipes.SERIALIZERS.register(bus);
        FCDParticleTypes.PARTICLES.register(bus);
        FCDMobEffects.EFFECTS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation modPrefix(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)FCDFluids.HOT_GREASE_FLUID_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.WATER_TYPE.get(), fluidState -> ((Block)FCDBlocks.LARD_BLOCK.get()).m_49966_()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)FCDBlocks.WILD_CANOLA.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)FCDItems.CANOLA_SEEDS.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)FCDItems.CANOLA.get()));
        });
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        boolean includeClient = event.includeClient();
        boolean includeServer = event.includeServer();
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(includeClient, (DataProvider)new FCDBlockStateProvider(packOutput, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new FCDItemModelProvider(packOutput, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new FCDSoundDefinitionsProvider(packOutput, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new FCDLangProvider(packOutput));
        FCDBlockTagsProvider blockTagProvider = new FCDBlockTagsProvider(packOutput, lookupProvider, fileHelper);
        generator.addProvider(includeServer, (DataProvider)blockTagProvider);
        generator.addProvider(includeServer, (DataProvider)new FCDItemTagsProvider(packOutput, lookupProvider, blockTagProvider.m_274426_(), fileHelper));
        generator.addProvider(includeServer, (DataProvider)new FCDBiomeTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new FCDFluidTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new FCDEntityTypeTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new FCDLootTableProvider(packOutput));
        generator.addProvider(includeServer, (DataProvider)new FCDAdvancementProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new FCDRecipeProvider(packOutput));
        generator.addProvider(includeServer, (DataProvider)new FCDDatapackBuiltinEntriesProvider(packOutput, lookupProvider));
    }
}

