/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FermentationRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ResourceLocation id;
    private final ItemStack container;

    public FermentationRecipe(NonNullList<Ingredient> ingredient, ItemStack output, ItemStack container, ResourceLocation id) {
        this.inputItems = ingredient;
        this.output = output;
        this.id = id;
        this.container = container.m_41619_() ? ItemStack.f_41583_ : container;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.f_46443_) {
            return false;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack item = pContainer.m_8020_(i);
            if (item.m_41619_()) continue;
            inputs.add(item);
        }
        if (inputs.size() != this.inputItems.size()) {
            return false;
        }
        ArrayList<Ingredient> ingredientsToCheck = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputItems);
        block1: for (ItemStack input : inputs) {
            for (Ingredient ingredient : ingredientsToCheck) {
                if (!ingredient.test(input)) continue;
                ingredientsToCheck.remove(ingredient);
                continue block1;
            }
            return false;
        }
        return true;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getContainer() {
        return this.container.m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public static class Serializer
    implements RecipeSerializer<FermentationRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("bakeries", "fermentation");

        public FermentationRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122779_();
            if (inputs.size() > 6) {
                throw new JsonParseException("Too many ingredients for coffee recipe! The max is 4");
            }
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            ItemStack container = GsonHelper.m_13900_((JsonObject)pSerializedRecipe, (String)"container") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"container"), (boolean)true) : ItemStack.f_41583_;
            return new FermentationRecipe((NonNullList<Ingredient>)inputs, output, container, pRecipeId);
        }

        @Nullable
        public FermentationRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int ingredientCount = pBuffer.readInt();
            NonNullList inputs = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientCount; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack container = pBuffer.m_130267_();
            ItemStack output = pBuffer.m_130267_();
            return new FermentationRecipe((NonNullList<Ingredient>)inputs, output, container, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, FermentationRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.inputItems.size());
            for (Ingredient ingredient : pRecipe.m_7527_()) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
            pBuffer.m_130055_(pRecipe.container);
        }
    }

    public static class Type
    implements RecipeType<FermentationRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "fermentation";
    }
}

