/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.item;

import com.mojang.datafixers.util.Pair;
import com.renyigesai.bakeries.api.block.properties.ModIntegerProperty;
import com.renyigesai.bakeries.api.item.FoodBlockItem;
import com.renyigesai.bakeries.util.ItemUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RepeatEatItem
extends FoodBlockItem {
    public RepeatEatItem(Block block, ModIntegerProperty integerProperty, Item.Properties pProperties, boolean effectTooltip, boolean customField) {
        super(block, integerProperty, pProperties, effectTooltip, customField);
    }

    public RepeatEatItem(Block block, ModIntegerProperty integerProperty, Item.Properties pProperties) {
        super(block, integerProperty, pProperties);
    }

    @Override
    public boolean isExtra(UseOnContext pContext) {
        return pContext.m_43722_().m_41773_() == 0;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        if (!this.canDrink()) {
            return UseAnim.EAT;
        }
        return UseAnim.DRINK;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean canDrink() {
        return false;
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (pStack.m_41773_() == pStack.m_41776_() - 1) {
            this.eat(pStack, pLevel, pLivingEntity, new Vec3(pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_()));
            this.addEffect(pLevel, pLivingEntity);
            return pStack.hasCraftingRemainingItem() && !pStack.getCraftingRemainingItem().m_41619_() ? super.m_5922_(this.residue(pStack), pLevel, pLivingEntity) : super.m_5922_(pStack, pLevel, pLivingEntity);
        }
        pStack.m_220157_(1, RandomSource.m_216327_(), null);
        this.eat(pStack, pLevel, pLivingEntity, new Vec3(pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_()));
        this.addEffect(pLevel, pLivingEntity);
        return pStack;
    }

    public static void rHurt(Player entity, ItemStack hand, ItemStack stack) {
        if (hand.m_41773_() == hand.m_41776_() - 1) {
            hand.m_41774_(1);
            ItemUtil.givePlayerItem(entity, stack);
        } else {
            hand.m_220157_(1, RandomSource.m_216327_(), null);
        }
    }

    public static void rHurt(ItemStack hand) {
        if (hand.m_41773_() == hand.m_41776_() - 1) {
            hand.m_41774_(1);
        } else {
            hand.m_220157_(1, RandomSource.m_216327_(), null);
        }
    }

    abstract void eat(ItemStack var1, Level var2, LivingEntity var3, Vec3 var4);

    public void addEffect(Level level, LivingEntity pLivingEntity) {
        List effects = Objects.requireNonNull(new ItemStack((ItemLike)this).getFoodProperties(pLivingEntity)).m_38749_();
        for (Pair effect : effects) {
            if (level.f_46443_ || effect.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)effect.getSecond()).floatValue())) continue;
            pLivingEntity.m_7292_(new MobEffectInstance((MobEffectInstance)effect.getFirst()));
        }
    }

    public ItemStack residue(ItemStack stack) {
        return stack.getCraftingRemainingItem();
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltip, isAdvanced);
        String translatable = this.canDrink() ? "item.bakeries.tips.repeat_eat_item.drink" : "item.bakeries.tips.repeat_eat_item";
        tooltip.add(Component.m_130674_((String)(Component.m_237115_((String)translatable).getString() + (stack.m_41776_() - stack.m_41773_()) + " / " + stack.m_41776_())));
    }
}

