/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.inventory;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class CustomButton {
    public ResourceLocation resourceLocation = new ResourceLocation("");
    public String name = "";
    public int pX;
    public int pX2;
    public int pY;
    public int pY2;
    public int pBlitOffset;
    public int pWidth;
    public int pHeight;
    public int pUWidth;
    public int pVHeight;
    public int pTextureWidth;
    public int pTextureHeight;
    public float u0;
    public float u1;
    public float v0;
    public float v1;
    public float pUOffset;
    public float pVOffset;
    public float pRed;
    public float pGreen;
    public float pBlue;
    public float pAlpha;

    public CustomButton() {
    }

    public CustomButton(GuiGraphics pGuiGraphics, int pX, int pY, int pBlitOffset, int pWidth, int pHeight, TextureAtlasSprite pSprite) {
        this.resourceLocation = pSprite.m_247685_();
        this.pX = pX;
        this.pX2 = pX + pWidth;
        this.pY = pY;
        this.pY2 = pY + pHeight;
        this.pBlitOffset = pBlitOffset;
        this.pWidth = pWidth;
        this.pHeight = pHeight;
        this.u0 = pSprite.m_118409_();
        this.u1 = pSprite.m_118410_();
        this.v0 = pSprite.m_118411_();
        this.v1 = pSprite.m_118412_();
        this.pTextureWidth = pWidth;
        this.pTextureHeight = pHeight;
        pGuiGraphics.m_280159_(pX, pY, pBlitOffset, pWidth, pHeight, pSprite);
    }

    public CustomButton(GuiGraphics pGuiGraphics, int pX, int pY, int pBlitOffset, int pWidth, int pHeight, TextureAtlasSprite pSprite, float pRed, float pGreen, float pBlue, float pAlpha) {
        this.resourceLocation = pSprite.m_247685_();
        this.pX = pX;
        this.pX2 = pX + pWidth;
        this.pY = pY;
        this.pY2 = pY + pHeight;
        this.pBlitOffset = pBlitOffset;
        this.pWidth = pWidth;
        this.pHeight = pHeight;
        this.u0 = pSprite.m_118409_();
        this.u1 = pSprite.m_118410_();
        this.v0 = pSprite.m_118411_();
        this.v1 = pSprite.m_118412_();
        this.pTextureWidth = pWidth;
        this.pTextureHeight = pHeight;
        this.pRed = pRed;
        this.pGreen = pGreen;
        this.pBlue = pBlue;
        this.pAlpha = pAlpha;
        pGuiGraphics.m_280565_(pX, pY, pBlitOffset, pWidth, pHeight, pSprite, pRed, pGreen, pBlue, pAlpha);
    }

    public CustomButton(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, int pX, int pY, int pUOffset, int pVOffset, int pUWidth, int pVHeight) {
        this.resourceLocation = pAtlasLocation;
        this.pX = pX;
        this.pY = pY;
        this.pBlitOffset = 0;
        this.pUOffset = pUOffset;
        this.pVOffset = pVOffset;
        this.pUWidth = pUWidth;
        this.pVHeight = pVHeight;
        this.pTextureWidth = 256;
        this.pTextureHeight = 256;
        pGuiGraphics.m_280218_(pAtlasLocation, pX, pY, pUOffset, pVOffset, pUWidth, pVHeight);
    }

    public CustomButton(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, int pX, int pY, int pBlitOffset, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight) {
        this.resourceLocation = pAtlasLocation;
        this.pX = pX;
        this.pY = pY;
        this.pBlitOffset = pBlitOffset;
        this.pUOffset = pUOffset;
        this.pVOffset = pVOffset;
        this.pUWidth = pUWidth;
        this.pVHeight = pVHeight;
        this.pTextureWidth = pTextureWidth;
        this.pTextureHeight = pTextureHeight;
        pGuiGraphics.m_280398_(pAtlasLocation, pX, pY, pBlitOffset, pUOffset, pVOffset, pUWidth, pVHeight, pTextureWidth, pTextureHeight);
    }

    public CustomButton(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, int pX, int pY, int pWidth, int pHeight, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight) {
        this.resourceLocation = pAtlasLocation;
        this.pX = pX;
        this.pY = pY;
        this.pWidth = pWidth;
        this.pHeight = pHeight;
        this.pBlitOffset = 0;
        this.pUOffset = pUOffset;
        this.pVOffset = pVOffset;
        this.pUWidth = pUWidth;
        this.pVHeight = pVHeight;
        this.pTextureWidth = pTextureWidth;
        this.pTextureHeight = pTextureHeight;
        pGuiGraphics.m_280411_(pAtlasLocation, pX, pY, pWidth, pHeight, pUOffset, pVOffset, pUWidth, pVHeight, pTextureWidth, pTextureHeight);
    }

    public CustomButton(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, int pX, int pY, float pUOffset, float pVOffset, int pWidth, int pHeight, int pTextureWidth, int pTextureHeight) {
        this.resourceLocation = pAtlasLocation;
        this.pX = pX;
        this.pY = pY;
        this.pWidth = pWidth;
        this.pHeight = pHeight;
        this.pUOffset = pUOffset;
        this.pVOffset = pVOffset;
        this.pTextureWidth = pTextureWidth;
        this.pTextureHeight = pTextureHeight;
        pGuiGraphics.m_280411_(pAtlasLocation, pX, pY, pWidth, pHeight, pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight);
    }

    private boolean insideScrollbar(double pMouseX, double pMouseY) {
        int x = this.pX;
        int y = this.pY;
        int pWidth = this.pWidth != 0 ? this.pWidth : 0;
        int pHeight = this.pHeight != 0 ? this.pHeight : 0;
        int w = pWidth != 0 ? pWidth : this.pUWidth;
        int h = pHeight != 0 ? pHeight : this.pVHeight;
        int width = this.pX + w;
        int height = this.pY + h;
        return pMouseX >= (double)x && pMouseY >= (double)y && pMouseX < (double)width && pMouseY < (double)height;
    }

    public void mouseClicked(AtomicBoolean isClicked, double pMouseX, double pMouseY, int pButton) {
        if (this.insideScrollbar(pMouseX, pMouseY)) {
            isClicked.set(true);
        }
    }

    public void mouseDragged(AtomicBoolean isClicked, double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (isClicked.get()) {
            this.updateProgress();
        }
    }

    public void mouseReleased(AtomicBoolean isClicked, double pMouseX, double pMouseY, int pButton) {
        if (isClicked.get()) {
            this.updateProgress();
            isClicked.set(false);
        }
    }

    protected abstract void updateProgress();

    public void renderName(GuiGraphics pGuiGraphics, Font font, String name, int pColor, boolean pDropShadow) {
        this.name = name;
        int pWidth = this.pWidth != 0 ? this.pWidth : 0;
        int pHeight = this.pHeight != 0 ? this.pHeight : 0;
        int w = pWidth != 0 ? pWidth : this.pUWidth;
        int h = pHeight != 0 ? pHeight : this.pVHeight;
        int width = (this.pX + w) / 2;
        int height = (this.pX + h) / 2;
        int txtX = width - font.m_92895_(name) / 2;
        Objects.requireNonNull(font);
        int txtY = height - 9 / 2;
        pGuiGraphics.m_280056_(font, name, txtX, txtY, pColor, pDropShadow);
    }
}

