/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.glass_drink_cup;

import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.recipe.CoffeeRecipe;
import com.renyigesai.bakeries.util.ItemUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;

public class GlassDrinkCupBlockEntity
extends BlockEntity {
    protected final ItemStackHandler inventory = new ItemStackHandler(5);
    public int stage;

    public GlassDrinkCupBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BakeriesBlocks.DRINK_CUP_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        if (tag.m_128441_("Stage")) {
            this.stage = tag.m_128451_("Stage");
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("Stage", this.stage);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean isInventoryFull() {
        for (int i = 0; i < this.inventory.getSlots() - 1; ++i) {
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void addItem(ItemStack stack, Player player) {
        for (int i = 0; i < this.inventory.getSlots() - 1; ++i) {
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            if (stack.hasCraftingRemainingItem()) {
                this.inventory.setStackInSlot(i, stack);
                ItemUtil.givePlayerItem(player, stack.getCraftingRemainingItem());
                break;
            }
            this.inventory.setStackInSlot(i, stack);
            break;
        }
        this.forcedRefresh();
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void forcedRefresh() {
        Optional<CoffeeRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isPresent()) {
            CoffeeRecipe coffeeRecipe = recipeOptional.get();
            this.inventory.setStackInSlot(4, coffeeRecipe.m_8043_(this.f_58857_.m_9598_()).m_41777_());
        }
    }

    public void removeItems() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void drops(GlassDrinkCupBlockEntity blockEntity) {
        SimpleContainer inventory = new SimpleContainer(blockEntity.inventory.getSlots());
        for (int i = 0; i < blockEntity.inventory.getSlots() - 1; ++i) {
            ItemStack stackInSlot = blockEntity.inventory.getStackInSlot(i);
            if (stackInSlot.hasCraftingRemainingItem()) continue;
            inventory.m_6836_(i, blockEntity.inventory.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    public Optional<CoffeeRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i < 4; ++i) {
            inventory.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)CoffeeRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GlassDrinkCupBlockEntity blockEntity) {
        if (!blockEntity.isInventoryFull()) {
            blockEntity.craftTick();
            if (!level.f_46443_) {
                level.m_7260_(pos, state, state, 2);
            }
        }
    }

    public void craftTick() {
        Optional<CoffeeRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isPresent()) {
            CoffeeRecipe recipe = recipeOptional.get();
            for (int i = 0; i < recipe.m_7527_().size() && !((Ingredient)recipe.m_7527_().get(i)).test(this.inventory.getStackInSlot(i)); ++i) {
            }
            this.inventory.setStackInSlot(4, recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_());
            this.m_6596_();
        }
    }
}

