/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.MixinUtils;
import com.mafuyu404.oneenoughitem.init.ReplacementCache;
import com.mafuyu404.oneenoughitem.init.config.Config;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SimpleJsonResourceReloadListener.class})
public abstract class SimpleJsonResourceReloadListenerMixin {
    @Shadow
    @Final
    private String f_10765_;

    @Inject(method={"prepare(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)Ljava/util/Map;"}, at={@At(value="RETURN")})
    private void oei$replaceItemIdsInJson(ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfoReturnable<Map<ResourceLocation, JsonElement>> cir) {
        MixinUtils.FieldRule baseRule = MixinUtils.getDataDirFieldRule(this.f_10765_);
        MixinUtils.ReplacementLoader.CurrentSnapshot snapshot = MixinUtils.ReplacementLoader.loadCurrentSnapshot(resourceManager);
        Map<String, String> currentItemMap = snapshot.itemMap();
        Map<String, Replacements.Rules> currentItemRules = snapshot.itemRules();
        if ("recipes".equals(this.f_10765_)) {
            ReplacementCache.beginReloadOverride(currentItemMap);
        }
        HashSet<String> currentSourceIds = new HashSet<String>(currentItemMap.keySet());
        if (currentItemMap.isEmpty() && !ReplacementCache.hasAnyMappings()) {
            return;
        }
        MixinUtils.FieldRule effectiveRule = new MixinUtils.FieldRule(baseRule.keys(), baseRule.strict());
        Map<String, Replacements.Rules> effectiveItemRules = SimpleJsonResourceReloadListenerMixin.getStringRulesMap(currentItemRules, currentItemMap);
        Map results = (Map)cir.getReturnValue();
        if (results == null || results.isEmpty()) {
            return;
        }
        int replacedFiles = 0;
        int droppedFiles = 0;
        boolean fallbackEnabled = currentItemMap.isEmpty();
        Iterator it = results.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            JsonElement json = (JsonElement)entry.getValue();
            if (json == null) continue;
            MixinUtils.ReplaceContext ctx = new MixinUtils.ReplaceContext(this.f_10765_, effectiveRule, currentItemMap, currentSourceIds, effectiveItemRules);
            ctx.allowCacheFallback = fallbackEnabled;
            try {
                JsonElement processed = this.replaceElement(json, ctx);
                if (ctx.shouldDrop) {
                    it.remove();
                    ++droppedFiles;
                    MixinUtils.LogHelper.logFileOperation("dropped", (ResourceLocation)entry.getKey(), this.f_10765_, ctx.lastMappingOrigin);
                    continue;
                }
                if (!ctx.mutated || processed == null) continue;
                entry.setValue(processed);
                ++replacedFiles;
                MixinUtils.LogHelper.logFileOperation("rewritten", (ResourceLocation)entry.getKey(), this.f_10765_, "RULE-BASED", fallbackEnabled);
            }
            catch (Exception e) {
                MixinUtils.LogHelper.logError("JSON rewrite", (ResourceLocation)entry.getKey(), this.f_10765_, e);
            }
        }
        if (replacedFiles > 0 || droppedFiles > 0) {
            MixinUtils.LogHelper.logSummary(this.f_10765_, replacedFiles, droppedFiles, "RULE-BASED", currentItemMap.isEmpty());
        }
    }

    @NotNull
    private static Map<String, Replacements.Rules> getStringRulesMap(Map<String, Replacements.Rules> currentItemRules, Map<String, String> currentItemMap) {
        Replacements.Rules defaultRules = null;
        try {
            Config.DefaultRules cfg = (Config.DefaultRules)Config.DEFAULT_RULES.getValue();
            if (cfg != null) {
                defaultRules = cfg.toRules();
            }
        }
        catch (Exception cfg) {
            // empty catch block
        }
        HashMap<String, Replacements.Rules> effectiveItemRules = new HashMap<String, Replacements.Rules>(currentItemRules);
        if (defaultRules != null) {
            for (String from : currentItemMap.keySet()) {
                effectiveItemRules.putIfAbsent(from, defaultRules);
            }
        }
        return effectiveItemRules;
    }

    private JsonElement replaceElement(JsonElement element, MixinUtils.ReplaceContext ctx) {
        if (element == null || ctx.shouldDrop) {
            return element;
        }
        if (element.isJsonObject()) {
            return this.replaceInObject(element.getAsJsonObject(), ctx);
        }
        if (element.isJsonArray()) {
            return this.replaceInArray(element.getAsJsonArray(), ctx);
        }
        return element;
    }

    private JsonElement replaceInObject(JsonObject obj, MixinUtils.ReplaceContext ctx) {
        if (ctx.shouldDrop) {
            return obj;
        }
        for (String key : new HashSet(obj.keySet())) {
            JsonElement value = obj.get(key);
            if (value == null) continue;
            if (ctx.rule.keys().contains(key) && value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
                MixinUtils.IdReplacer.tryReplaceId(obj, key, value.getAsString(), ctx);
                if (!ctx.shouldDrop) continue;
                return obj;
            }
            if (value.isJsonObject()) {
                obj.add(key, this.replaceInObject(value.getAsJsonObject(), ctx));
                continue;
            }
            if (!value.isJsonArray()) continue;
            obj.add(key, this.replaceInArray(value.getAsJsonArray(), ctx));
        }
        return obj;
    }

    private JsonElement replaceInArray(JsonArray array, MixinUtils.ReplaceContext ctx) {
        if (ctx.shouldDrop) {
            return array;
        }
        for (int i = 0; i < array.size(); ++i) {
            JsonElement elt = array.get(i);
            if (elt == null) continue;
            if (elt.isJsonObject()) {
                array.set(i, this.replaceInObject(elt.getAsJsonObject(), ctx));
                continue;
            }
            if (elt.isJsonArray()) {
                array.set(i, this.replaceInArray(elt.getAsJsonArray(), ctx));
                continue;
            }
            if (!elt.isJsonPrimitive() || !elt.getAsJsonPrimitive().isString()) continue;
            MixinUtils.IdReplacer.tryReplaceId(array, i, elt.getAsString(), ctx);
            if (!ctx.shouldDrop) continue;
            return array;
        }
        return array;
    }
}

