/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.mixin;

import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.client.ClientContext;
import com.mafuyu404.oneenoughitem.init.ReplacementCache;
import com.mafuyu404.oneenoughitem.init.ReplacementControl;
import com.mafuyu404.oneenoughitem.init.Utils;
import com.mafuyu404.oneenoughitem.init.config.Config;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Mutable
    @Shadow
    @Final
    @Deprecated
    @javax.annotation.Nullable
    private Item f_41589_;
    @Mutable
    @Shadow
    @Final
    @Nullable
    private Holder.Reference<Item> delegate;

    @Shadow
    public abstract Item m_41720_();

    @Inject(method={"forgeInit"}, at={@At(value="HEAD")}, remap=false)
    private void replace(CallbackInfo ci) {
        if (this.f_41589_ == null) {
            return;
        }
        if (ReplacementControl.shouldSkipReplacement()) {
            return;
        }
        try {
            String originItemId = Utils.getItemRegistryName(this.f_41589_);
            if (originItemId == null) {
                return;
            }
            String targetItemId = ReplacementCache.matchItem(originItemId);
            if (targetItemId != null) {
                if (targetItemId.equals("minecraft:air") && this.isInCreativeModeTabBuilding()) {
                    return;
                }
                Item replacementItem = Utils.getItemById(targetItemId);
                if (replacementItem != null) {
                    this.f_41589_ = replacementItem;
                    this.delegate = ForgeRegistries.ITEMS.getDelegateOrThrow((Object)replacementItem);
                } else {
                    Oneenoughitem.LOGGER.warn("ItemStackMixin: Replacement item is null for targetItemId: {}, original item: {}", (Object)targetItemId, (Object)originItemId);
                }
            }
        }
        catch (Exception e) {
            String itemInfo = this.f_41589_ != null ? Utils.getItemRegistryName(this.f_41589_) : "null";
            Oneenoughitem.LOGGER.error("ItemStackMixin: Failed to replace item: {}", (Object)itemInfo, (Object)e);
        }
    }

    @Inject(method={"is(Ljava/util/function/Predicate;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void extend(Predicate<Holder<Item>> predicate, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)Config.DEEPER_REPLACE.getValue()).booleanValue()) {
            return;
        }
        if (!predicate.test((Holder<Item>)this.m_41720_().m_204114_())) {
            String itemId = Utils.getItemRegistryName(this.f_41589_);
            boolean matched = false;
            for (Item matchItem : ReplacementCache.trackSourceOf(itemId)) {
                if (!predicate.test((Holder<Item>)matchItem.m_204114_())) continue;
                matched = true;
            }
            cir.setReturnValue((Object)matched);
        }
    }

    @Inject(method={"is(Lnet/minecraft/core/Holder;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void extend(Holder<Item> itemHolder, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)Config.DEEPER_REPLACE.getValue()).booleanValue()) {
            return;
        }
        if (this.m_41720_().m_204114_() != itemHolder) {
            String itemId = Utils.getItemRegistryName(this.f_41589_);
            boolean matched = false;
            for (Item matchItem : ReplacementCache.trackSourceOf(itemId)) {
                if (matchItem.m_204114_() != itemHolder) continue;
                matched = true;
                break;
            }
            cir.setReturnValue((Object)matched);
        }
    }

    @Inject(method={"is(Lnet/minecraft/world/item/Item;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void extend(Item inputItem, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)Config.DEEPER_REPLACE.getValue()).booleanValue()) {
            return;
        }
        if (this.f_41589_ != inputItem) {
            String inputItemId = Utils.getItemRegistryName(inputItem);
            String ItemId = Utils.getItemRegistryName(this.f_41589_);
            if (Utils.isItemIdEmpty(inputItemId) || Utils.isItemIdEmpty(ItemId)) {
                return;
            }
            boolean matched = false;
            for (String matchId : ReplacementCache.trackSourceIdOf(ItemId)) {
                if (!matchId.equals(inputItemId)) continue;
                matched = true;
                break;
            }
            cir.setReturnValue((Object)matched);
        }
    }

    private boolean isInCreativeModeTabBuilding() {
        return ClientContext.isBuilding();
    }
}

