/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.init;

import com.mafuyu404.oneenoughitem.Oneenoughitem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class Utils {
    public static String getItemRegistryName(Item item) {
        if (item == null) {
            return null;
        }
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)item);
        if (registryName == null) {
            Oneenoughitem.LOGGER.warn("getItemRegistryName: registryName is null for item: {}", (Object)item.getClass().getName());
            return null;
        }
        return registryName.toString();
    }

    public static Item getItemById(String registryName) {
        if (registryName == null || registryName.isEmpty()) {
            Oneenoughitem.LOGGER.debug("getItemById: registryName is null or empty");
            return null;
        }
        try {
            ResourceLocation resourceLocation = new ResourceLocation(registryName);
            if (!ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
                Oneenoughitem.LOGGER.debug("getItemById: Item '{}' not found in registry", (Object)registryName);
                return null;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            return item;
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.debug("getItemById: Exception while getting item for registry name: {}", (Object)registryName, (Object)e);
            return null;
        }
    }

    public static Collection<Item> getItemsOfTag(ResourceLocation tagId) {
        TagKey tagKey = ForgeRegistries.ITEMS.tags().createTagKey(tagId);
        ITagManager tagManager = ForgeRegistries.ITEMS.tags();
        HashSet<Item> result = new HashSet<Item>();
        if (tagManager != null && tagManager.isKnownTagName(tagKey)) {
            tagManager.getTag(tagKey).forEach(result::add);
        }
        return result;
    }

    public static boolean isTagExists(ResourceLocation tagId) {
        TagKey tagKey = ForgeRegistries.ITEMS.tags().createTagKey(tagId);
        ITagManager tagManager = ForgeRegistries.ITEMS.tags();
        return tagManager != null && tagManager.isKnownTagName(tagKey);
    }

    public static List<Item> resolveItemList(List<String> identifiers) {
        ArrayList<Item> result = new ArrayList<Item>();
        for (String id : identifiers) {
            if (id == null || id.isEmpty()) continue;
            if (id.startsWith("#")) {
                String tagIdString = id.substring(1);
                try {
                    ResourceLocation tagId = new ResourceLocation(tagIdString);
                    Collection<Item> tagItems = Utils.getItemsOfTag(tagId);
                    if (tagItems.isEmpty()) {
                        Oneenoughitem.LOGGER.warn("Tag {} is empty or not found", (Object)tagId);
                        continue;
                    }
                    result.addAll(tagItems);
                    Oneenoughitem.LOGGER.debug("Resolved tag {} to {} items", (Object)tagId, (Object)tagItems.size());
                }
                catch (Exception e) {
                    Oneenoughitem.LOGGER.error("Invalid tag ID format: {}", (Object)id, (Object)e);
                }
                continue;
            }
            Item item = Utils.getItemById(id);
            if (item != null) {
                result.add(item);
                continue;
            }
            Oneenoughitem.LOGGER.warn("Item ID not found: {}", (Object)id);
        }
        return result;
    }

    public static List<ResourceLocation> getItemTags(Item item) {
        ITagManager tagManager = ForgeRegistries.ITEMS.tags();
        if (tagManager == null) {
            return Collections.emptyList();
        }
        return tagManager.getReverseTag((Object)item).map(reverseTag -> reverseTag.getTagKeys().map(TagKey::f_203868_).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static boolean isItemIdEmpty(String id) {
        return id == null || id.equals("minecraft:air");
    }
}

