/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.event;

import com.mafuyu404.oelib.forge.data.DataManager;
import com.mafuyu404.oelib.forge.event.DataReloadEvent;
import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.ReplacementCache;
import com.mafuyu404.oneenoughitem.init.config.Config;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="oneenoughitem")
public class ServerEventHandler {
    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        ServerEventHandler.rebuildReplacementCache("server-start");
    }

    @SubscribeEvent
    public static void onDataReload(DataReloadEvent event) {
        if (event.isDataType(Replacements.class)) {
            ServerEventHandler.rebuildReplacementCache("data-reload");
            Oneenoughitem.LOGGER.info("Server replacement cache rebuilt due to data reload: {} entries loaded, {} invalid", (Object)event.getLoadedCount(), (Object)event.getInvalidCount());
            ReplacementCache.endReloadOverride();
        }
    }

    private static void rebuildReplacementCache(String reason) {
        DataManager manager = DataManager.get(Replacements.class);
        if (manager != null) {
            ReplacementCache.clearCache();
            List replacements = manager.getDataList();
            for (Replacements replacement : replacements) {
                Replacements toPut = ServerEventHandler.getReplacements(replacement);
                ReplacementCache.putReplacement(toPut);
            }
            Oneenoughitem.LOGGER.debug("Server rebuilt replacement cache (reason: {}) with {} rules", (Object)reason, (Object)replacements.size());
        } else {
            Oneenoughitem.LOGGER.warn("ServerEventHandler: No replacement data manager found in OELib (reason: {})", (Object)reason);
        }
    }

    @NotNull
    private static Replacements getReplacements(Replacements replacement) {
        Config.DefaultRules cfg;
        Replacements toPut = replacement;
        if (replacement.rules().isEmpty() && (cfg = (Config.DefaultRules)Config.DEFAULT_RULES.getValue()) != null) {
            toPut = new Replacements(replacement.matchItems(), replacement.resultItems(), Optional.of(cfg.toRules()));
        }
        return toPut;
    }
}

