/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.event;

import com.mafuyu404.oelib.forge.data.DataManager;
import com.mafuyu404.oelib.forge.event.DataReloadEvent;
import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.client.ModKeyMappings;
import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.cache.GlobalReplacementCache;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.ReplacementCache;
import com.mafuyu404.oneenoughitem.init.access.CreativeModeTabIconRefresher;
import com.mafuyu404.oneenoughitem.init.config.Config;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(modid="oneenoughitem", value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ModKeyMappings.OPEN_EDITOR);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            if (ModKeyMappings.OPEN_EDITOR.m_90859_() && mc.f_91080_ == null && ClientEventHandler.hasCtrlDown()) {
                mc.m_91152_((Screen)new ReplacementEditorScreen());
            }
        }
    }

    @SubscribeEvent
    public static void onDataReload(DataReloadEvent event) {
        if (event.isDataType(Replacements.class)) {
            Minecraft.m_91087_().execute(() -> {
                ClientEventHandler.rebuildReplacementCache();
                GlobalReplacementCache.rebuild();
                ClientEventHandler.refreshAllCreativeModeTabIcons();
                Oneenoughitem.LOGGER.info("Replacement cache rebuilt due to data reload: {} entries loaded, {} invalid", (Object)event.getLoadedCount(), (Object)event.getInvalidCount());
                ReplacementCache.endReloadOverride();
            });
        }
    }

    private static void refreshAllCreativeModeTabIcons() {
        try {
            for (CreativeModeTab tab : CreativeModeTabs.m_257388_()) {
                if (!(tab instanceof CreativeModeTabIconRefresher)) continue;
                CreativeModeTabIconRefresher refresher = (CreativeModeTabIconRefresher)tab;
                refresher.oei$refreshIconCache();
            }
            Oneenoughitem.LOGGER.info("Refreshed creative mode tab icons after replacement reload");
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("Failed to refresh creative mode tab icons", (Throwable)e);
        }
    }

    private static boolean hasCtrlDown() {
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        return GLFW.glfwGetKey((long)window, (int)341) == 1 || GLFW.glfwGetKey((long)window, (int)345) == 1;
    }

    private static void rebuildReplacementCache() {
        DataManager manager = DataManager.get(Replacements.class);
        if (manager != null) {
            ReplacementCache.clearCache();
            List replacements = manager.getDataList();
            for (Replacements replacement : replacements) {
                Replacements toPut = ClientEventHandler.getReplacements(replacement);
                ReplacementCache.putReplacement(toPut);
            }
            Oneenoughitem.LOGGER.debug("Rebuilt replacement cache with {} rules from OELib data manager", (Object)replacements.size());
        } else {
            Oneenoughitem.LOGGER.warn("No replacement data manager found in OELib");
        }
    }

    @NotNull
    private static Replacements getReplacements(Replacements replacement) {
        Config.DefaultRules cfg;
        Replacements toPut = replacement;
        if (replacement.rules().isEmpty() && (cfg = (Config.DefaultRules)Config.DEFAULT_RULES.getValue()) != null) {
            toPut = new Replacements(replacement.matchItems(), replacement.resultItems(), Optional.of(cfg.toRules()));
        }
        return toPut;
    }
}

