/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.data;

import com.mafuyu404.oelib.api.data.DataValidator;
import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.Utils;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ReplacementValidator
implements DataValidator<Replacements> {
    public DataValidator.ValidationResult validate(Replacements replacement, ResourceLocation source) {
        if (Utils.getItemById(replacement.resultItems()) == null) {
            return DataValidator.ValidationResult.failure((String)("Target item '" + replacement.resultItems() + "' does not exist"));
        }
        boolean hasValidSource = false;
        boolean hasUnresolvedTags = false;
        int validSourceCount = 0;
        for (String matchItem : replacement.matchItems()) {
            if (matchItem.startsWith("#")) {
                String tagIdString = matchItem.substring(1);
                try {
                    ResourceLocation tagId = new ResourceLocation(tagIdString);
                    if (Utils.isTagExists(tagId)) {
                        Collection<Item> tagItems = Utils.getItemsOfTag(tagId);
                        if (!tagItems.isEmpty()) {
                            hasValidSource = true;
                            validSourceCount += tagItems.size();
                            Oneenoughitem.LOGGER.debug("Valid tag in {}: '{}' contains {} items", (Object)source, (Object)matchItem, (Object)tagItems.size());
                            continue;
                        }
                        Oneenoughitem.LOGGER.warn("Tag in {} is empty: '{}'", (Object)source, (Object)matchItem);
                        continue;
                    }
                    hasUnresolvedTags = true;
                    Oneenoughitem.LOGGER.debug("Tag in {} not found (may be uninitialized): '{}'", (Object)source, (Object)matchItem);
                    continue;
                }
                catch (Exception e) {
                    Oneenoughitem.LOGGER.error("Invalid tag format in {}: '{}'", (Object)source, (Object)matchItem, (Object)e);
                    return DataValidator.ValidationResult.failure((String)("Invalid tag format: " + matchItem));
                }
            }
            if (Utils.getItemById(matchItem) != null) {
                hasValidSource = true;
                ++validSourceCount;
                continue;
            }
            Oneenoughitem.LOGGER.warn("Invalid source item in {}: '{}' does not exist", (Object)source, (Object)matchItem);
        }
        if (!hasValidSource && hasUnresolvedTags) {
            return DataValidator.ValidationResult.deferred((String)"Contains unresolved tags, validation deferred until tag system is ready");
        }
        if (!hasValidSource) {
            return DataValidator.ValidationResult.failure((String)("No valid source items found for target '" + replacement.resultItems() + "'"));
        }
        Oneenoughitem.LOGGER.debug("Replacement in {} validated: {} source items -> {}", (Object)source, (Object)validSourceCount, (Object)replacement.resultItems());
        return DataValidator.ValidationResult.success();
    }
}

