/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.client.gui.cache.GlobalReplacementCache;
import com.mafuyu404.oneenoughitem.client.gui.util.PathUtils;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.ReplacementCache;
import com.mafuyu404.oneenoughitem.init.Utils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class ReplacementEditorManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Set<Item> matchItems = new HashSet<Item>();
    private final Set<ResourceLocation> matchTags = new HashSet<ResourceLocation>();
    private Item resultItem;
    private ResourceLocation resultTag;
    private Path currentFilePath;
    private String currentFileName = "";
    private int currentObjectIndex = -1;
    private JsonArray currentJsonObjects;
    private Runnable uiUpdateCallback;

    public Set<Item> getMatchItems() {
        return new HashSet<Item>(this.matchItems);
    }

    public Set<ResourceLocation> getMatchTags() {
        return new HashSet<ResourceLocation>(this.matchTags);
    }

    public Item getResultItem() {
        return this.resultItem;
    }

    public ResourceLocation getResultTag() {
        return this.resultTag;
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public Path getCurrentFilePath() {
        return this.currentFilePath;
    }

    public int getCurrentObjectIndex() {
        return this.currentObjectIndex;
    }

    public int getObjectSize() {
        return this.currentJsonObjects != null ? this.currentJsonObjects.size() : 0;
    }

    public void setUiUpdateCallback(Runnable callback) {
        this.uiUpdateCallback = callback;
    }

    private void notifyUiUpdate() {
        if (this.uiUpdateCallback != null) {
            this.uiUpdateCallback.run();
        }
    }

    public void addMatchItem(Item item) {
        this.matchItems.add(item);
    }

    public void addMatchTag(ResourceLocation tagId) {
        this.matchTags.add(tagId);
    }

    public void removeMatchTag(ResourceLocation tagId) {
        this.matchTags.remove(tagId);
    }

    public boolean removeMatchItem(Item item) {
        String targetItemId = Utils.getItemRegistryName(item);
        if (targetItemId == null) {
            Oneenoughitem.LOGGER.warn("removeMatchItem: Target item ID is null for item: {}", (Object)item);
            return false;
        }
        return this.matchItems.removeIf(existingItem -> {
            String existingItemId = Utils.getItemRegistryName(existingItem);
            return targetItemId.equals(existingItemId);
        });
    }

    public void setResultItem(Item item) {
        this.resultItem = item;
        this.resultTag = null;
    }

    public void setResultTag(ResourceLocation tagId) {
        this.resultTag = tagId;
        this.resultItem = null;
    }

    public void clearMatchItems() {
        this.matchItems.clear();
        this.matchTags.clear();
    }

    public void clearResultItem() {
        this.resultItem = null;
        this.resultTag = null;
    }

    public void clearAll() {
        this.clearMatchItems();
        this.clearResultItem();
        this.currentFileName = "";
        this.currentFilePath = null;
        this.currentObjectIndex = -1;
        this.currentJsonObjects = null;
    }

    public void setCurrentObjectIndex(int index) {
        this.currentObjectIndex = index;
        if (index >= 0 && this.currentJsonObjects != null && index < this.currentJsonObjects.size()) {
            this.loadReplacementFromObject(index);
        } else {
            this.clearMatchItems();
            this.clearResultItem();
            this.notifyUiUpdate();
        }
    }

    private void loadReplacementFromObject(int index) {
        this.executeWithErrorHandling(() -> {
            JsonElement element = this.currentJsonObjects.get(index);
            DataResult result = Replacements.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (result.result().isPresent()) {
                Replacements replacement = (Replacements)result.result().get();
                this.clearMatchItems();
                this.clearResultItem();
                for (String matchItem : replacement.matchItems()) {
                    if (matchItem.startsWith("#")) {
                        this.matchTags.add(new ResourceLocation(matchItem.substring(1)));
                        continue;
                    }
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(matchItem));
                    if (item == null || item == Items.f_41852_) continue;
                    this.matchItems.add(item);
                }
                String resultString = replacement.resultItems();
                if (resultString.startsWith("#")) {
                    this.resultTag = new ResourceLocation(resultString.substring(1));
                } else {
                    this.resultItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultString));
                }
                this.notifyUiUpdate();
                this.showMessage((Component)Component.m_237110_((String)"message.oneenoughitem.object_loaded", (Object[])new Object[]{index + 1}).m_130940_(ChatFormatting.GREEN));
            } else {
                this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.object_parse_failed", (Object[])new Object[]{index + 1}).m_130940_(ChatFormatting.RED));
            }
        }, e -> this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.object_load_error", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED)));
    }

    public void deleteObjectElement(int index) {
        if (this.currentJsonObjects == null || index < 0 || index >= this.currentJsonObjects.size()) {
            this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.object_index_invalid").m_130940_(ChatFormatting.RED));
            return;
        }
        this.executeWithErrorHandling(() -> {
            JsonElement element = this.currentJsonObjects.get(index);
            this.removeReplacementFromCache(element);
            this.currentJsonObjects.remove(index);
            this.saveJsonObjectsToFile(this.currentJsonObjects);
            this.showMessage((Component)Component.m_237110_((String)"message.oneenoughitem.object_element_deleted", (Object[])new Object[]{index + 1}).m_130940_(ChatFormatting.GREEN));
            if (this.currentJsonObjects.isEmpty()) {
                Oneenoughitem.LOGGER.debug("JSON array is now empty, rebuilding global cache to ensure consistency");
                GlobalReplacementCache.rebuild();
            }
        }, e -> this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.object_delete_failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED)));
    }

    private void removeReplacementFromCache(JsonElement element) {
        DataResult result = Replacements.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
        if (result.result().isPresent()) {
            Replacements replacement = (Replacements)result.result().get();
            ArrayList<String> matchItemsList = new ArrayList<String>();
            ArrayList<String> matchTagsList = new ArrayList<String>();
            for (String matchItem : replacement.matchItems()) {
                if (matchItem.startsWith("#")) {
                    matchTagsList.add(matchItem.substring(1));
                    continue;
                }
                matchItemsList.add(matchItem);
            }
            GlobalReplacementCache.removeReplacement(matchItemsList, matchTagsList);
            ReplacementCache.removeReplacements(matchItemsList, matchTagsList);
            Oneenoughitem.LOGGER.debug("Removed replacement from both global and runtime cache: items={}, tags={}", matchItemsList, matchTagsList);
        }
    }

    public void createReplacementFile(String datapackName, String fileName) {
        this.executeWithErrorHandling(() -> {
            Path datapackPath = PathUtils.getDatapackPath(datapackName);
            Path replacementsPath = datapackPath.resolve("data/oei/replacements");
            Files.createDirectories(replacementsPath, new FileAttribute[0]);
            this.createPackMcmetaIfNeeded(datapackPath);
            Path filePath = replacementsPath.resolve(fileName + ".json");
            if (Files.exists(filePath, new LinkOption[0])) {
                this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.file_already_exists", (Object[])new Object[]{fileName + ".json"}).m_130940_(ChatFormatting.RED));
                return;
            }
            JsonArray emptyObjects = new JsonArray();
            try (FileWriter writer = new FileWriter(filePath.toFile());){
                GSON.toJson((JsonElement)emptyObjects, (Appendable)writer);
            }
            this.currentFilePath = filePath;
            this.currentFileName = fileName;
            this.currentJsonObjects = emptyObjects;
            this.currentObjectIndex = -1;
            this.showMessage((Component)Component.m_237110_((String)"message.oneenoughitem.file_created", (Object[])new Object[]{filePath.toString()}).m_130940_(ChatFormatting.GREEN));
            Oneenoughitem.LOGGER.info("Created replacement file: {}", (Object)filePath);
        }, e -> this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.file_create_failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED)));
    }

    private void createPackMcmetaIfNeeded(Path datapackPath) throws IOException {
        Path packMcmetaPath = datapackPath.resolve("pack.mcmeta");
        if (!Files.exists(packMcmetaPath, new LinkOption[0])) {
            String packMcmetaContent = "{\n   \"pack\": {\n     \"description\": \"The automatically generated OEI data pack\",\n     \"pack_format\": 15\n   }\n}";
            try (FileWriter writer = new FileWriter(packMcmetaPath.toFile());){
                writer.write(packMcmetaContent);
            }
            Oneenoughitem.LOGGER.info("Created pack.mcmeta file: {}", (Object)packMcmetaPath);
        }
    }

    public void selectJsonFile(Path selectedPath, int mode) {
        this.executeWithErrorHandling(() -> {
            this.currentFilePath = selectedPath;
            String fileName = selectedPath.getFileName().toString();
            String string = this.currentFileName = fileName.endsWith(".json") ? fileName.substring(0, fileName.length() - 5) : fileName;
            if (!Files.exists(this.currentFilePath, new LinkOption[0])) {
                this.createEmptyJsonFile();
            } else {
                this.currentJsonObjects = this.readExistingJsonObjects();
            }
            this.clearMatchItems();
            this.clearResultItem();
            this.setupModeAndIndex(mode);
            this.notifyUiUpdate();
            String modeKey = this.getModeTranslationKey(mode);
            this.showMessage((Component)Component.m_237110_((String)"message.oneenoughitem.file_selected", (Object[])new Object[]{fileName, Component.m_237115_((String)modeKey)}).m_130940_(ChatFormatting.GREEN));
        }, e -> this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.file_select_failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED)));
    }

    private void createEmptyJsonFile() throws IOException {
        Files.createDirectories(this.currentFilePath.getParent(), new FileAttribute[0]);
        JsonArray emptyObjects = new JsonArray();
        try (FileWriter writer = new FileWriter(this.currentFilePath.toFile());){
            GSON.toJson((JsonElement)emptyObjects, (Appendable)writer);
        }
        this.currentJsonObjects = emptyObjects;
    }

    private void setupModeAndIndex(int mode) {
        if (mode == 1) {
            this.currentObjectIndex = 0;
            if (!this.currentJsonObjects.isEmpty()) {
                this.loadReplacementFromObject(0);
            } else {
                this.currentObjectIndex = -1;
            }
        } else {
            this.currentObjectIndex = -1;
        }
    }

    private String getModeTranslationKey(int mode) {
        return switch (mode) {
            case 0 -> "mode.oneenoughitem.add";
            case 1 -> "mode.oneenoughitem.modify";
            case 2 -> "mode.oneenoughitem.remove";
            default -> "mode.oneenoughitem.unknown";
        };
    }

    public String getObjectElementDescription(int index) {
        if (this.currentJsonObjects == null || index < 0 || index >= this.currentJsonObjects.size()) {
            return Component.m_237115_((String)"description.oneenoughitem.invalid").getString();
        }
        try {
            JsonElement element = this.currentJsonObjects.get(index);
            DataResult result = Replacements.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (result.result().isPresent()) {
                Replacements replacement = (Replacements)result.result().get();
                int matchCount = replacement.matchItems().size();
                String resultType = replacement.resultItems().startsWith("#") ? Component.m_237115_((String)"description.oneenoughitem.tag").getString() : Component.m_237115_((String)"description.oneenoughitem.item").getString();
                return Component.m_237110_((String)"description.oneenoughitem.items_to_type", (Object[])new Object[]{matchCount, resultType}).getString();
            }
            return Component.m_237115_((String)"description.oneenoughitem.parse_failed").getString();
        }
        catch (Exception e) {
            return Component.m_237115_((String)"description.oneenoughitem.error").getString();
        }
    }

    public void setCurrentFileName(String fileName) {
        this.currentFileName = fileName != null ? fileName : "";
    }

    public void saveReplacement() {
        ValidationResult validation = this.validateReplacementInput();
        if (!validation.isValid()) {
            this.showError(validation.errorMessage());
            return;
        }
        if (this.currentFilePath == null) {
            this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.no_file_selected").m_130940_(ChatFormatting.RED));
            return;
        }
        this.executeWithErrorHandling(() -> {
            ReplacementData data = this.prepareReplacementData();
            GlobalReplacementCache.addReplacement(data.matchItemsList(), data.matchTagsList(), data.resultItemString().startsWith("#") ? null : data.resultItemString(), data.resultItemString().startsWith("#") ? data.resultItemString() : null, this.currentFileName);
            ArrayList<String> allMatchItems = new ArrayList<String>(data.matchItemsList());
            for (String tag : data.matchTagsList()) {
                allMatchItems.add("#" + tag);
            }
            Replacements replacement = new Replacements(allMatchItems, data.resultItemString(), Optional.empty());
            DataResult result = Replacements.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)replacement);
            if (result.result().isEmpty()) {
                this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.encode_failed").m_130940_(ChatFormatting.RED));
                return;
            }
            JsonElement replacementElement = (JsonElement)result.result().get();
            if (this.currentObjectIndex >= 0) {
                this.updateExistingObject(replacementElement);
            } else {
                this.addNewObject(replacementElement);
            }
            this.saveJsonObjectsToFile(this.currentJsonObjects);
            Oneenoughitem.LOGGER.info("Saved replacement to file: {}", (Object)this.currentFilePath);
        }, e -> {
            if (e instanceof IOException) {
                this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.save_failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED));
            } else {
                this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.unexpected_error", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED));
            }
        });
    }

    private ValidationResult validateReplacementInput() {
        boolean hasResultItem;
        boolean hasMatchItems = !this.matchItems.isEmpty() || !this.matchTags.isEmpty();
        boolean bl = hasResultItem = this.resultItem != null || this.resultTag != null;
        if (!hasMatchItems && !hasResultItem) {
            return new ValidationResult(false, (Component)Component.m_237115_((String)"error.oneenoughitem.both_empty").m_130940_(ChatFormatting.RED));
        }
        if (!hasMatchItems) {
            return new ValidationResult(false, (Component)Component.m_237115_((String)"error.oneenoughitem.missing_match_items").m_130940_(ChatFormatting.RED));
        }
        if (!hasResultItem) {
            return new ValidationResult(false, (Component)Component.m_237115_((String)"error.oneenoughitem.missing_result_item").m_130940_(ChatFormatting.RED));
        }
        return new ValidationResult(true, null);
    }

    private ReplacementData prepareReplacementData() {
        ArrayList<String> matchItemsList = new ArrayList<String>();
        ArrayList<String> matchTagsList = new ArrayList<String>();
        for (Item item : this.matchItems) {
            String itemId = Utils.getItemRegistryName(item);
            if (itemId == null) continue;
            matchItemsList.add(itemId);
        }
        for (ResourceLocation tagId : this.matchTags) {
            matchTagsList.add(tagId.toString());
        }
        String resultItemString = this.getResultItemString();
        if (resultItemString == null) {
            throw new RuntimeException("Failed to get result item string");
        }
        return new ReplacementData(matchItemsList, matchTagsList, resultItemString);
    }

    private void updateExistingObject(JsonElement replacementElement) {
        if (this.currentObjectIndex >= this.currentJsonObjects.size()) {
            this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.object_index_out_of_bounds").m_130940_(ChatFormatting.RED));
            throw new RuntimeException("Object index out of bounds");
        }
        this.currentJsonObjects.set(this.currentObjectIndex, replacementElement);
        this.showMessage((Component)Component.m_237110_((String)"message.oneenoughitem.object_updated", (Object[])new Object[]{this.currentObjectIndex + 1}).m_130940_(ChatFormatting.GREEN));
    }

    private void addNewObject(JsonElement replacementElement) {
        this.currentJsonObjects.add(replacementElement);
        this.showMessage((Component)Component.m_237110_((String)"message.oneenoughitem.replacement_added", (Object[])new Object[]{this.currentFilePath.getFileName().toString()}).m_130940_(ChatFormatting.GREEN));
    }

    public void deleteFile(Path filePath) {
        this.executeWithErrorHandling(() -> {
            if (Files.exists(filePath, new LinkOption[0])) {
                Files.delete(filePath);
                this.showMessage((Component)Component.m_237110_((String)"message.oneenoughitem.file_deleted", (Object[])new Object[]{filePath.getFileName().toString()}).m_130940_(ChatFormatting.GREEN));
                if (filePath.equals(this.currentFilePath)) {
                    this.resetCurrentFile();
                }
            } else {
                this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.file_not_exists", (Object[])new Object[]{filePath.toString()}).m_130940_(ChatFormatting.RED));
            }
        }, e -> this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.file_delete_failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED)));
    }

    private void resetCurrentFile() {
        this.currentFilePath = null;
        this.currentFileName = "";
        this.currentJsonObjects = null;
        this.currentObjectIndex = -1;
        this.clearMatchItems();
        this.clearResultItem();
        this.notifyUiUpdate();
    }

    private String getResultItemString() {
        if (this.resultItem != null) {
            String resultItemString = Utils.getItemRegistryName(this.resultItem);
            if (resultItemString == null) {
                this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.result_item_name_failed").m_130940_(ChatFormatting.RED));
                return null;
            }
            return resultItemString;
        }
        if (this.resultTag != null) {
            return "#" + String.valueOf(this.resultTag);
        }
        this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.no_result_item").m_130940_(ChatFormatting.RED));
        return null;
    }

    private void executeWithErrorHandling(RunnableWithException operation, Consumer<Exception> errorHandler) {
        try {
            operation.run();
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.error("Operation failed", (Throwable)e);
            errorHandler.accept(e);
        }
    }

    private void showMessage(Component message) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_213846_(message);
        }
    }

    private void showError(Component message) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_213846_(message);
        }
    }

    private JsonArray readExistingJsonObjects() {
        JsonArray existingObjects;
        block6: {
            if (Files.exists(this.currentFilePath, new LinkOption[0])) {
                try {
                    String content = Files.readString(this.currentFilePath);
                    if (content.trim().isEmpty()) {
                        existingObjects = new JsonArray();
                        break block6;
                    }
                    JsonElement parsed = (JsonElement)GSON.fromJson(content, JsonElement.class);
                    if (parsed != null && parsed.isJsonArray()) {
                        existingObjects = parsed.getAsJsonArray();
                        break block6;
                    }
                    this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.file_format_error").m_130940_(ChatFormatting.RED));
                    existingObjects = new JsonArray();
                }
                catch (Exception e) {
                    this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.file_parse_failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED));
                    Oneenoughitem.LOGGER.warn("Failed to parse existing file, creating new objects", (Throwable)e);
                    existingObjects = new JsonArray();
                }
            } else {
                existingObjects = new JsonArray();
            }
        }
        return existingObjects;
    }

    private void saveJsonObjectsToFile(JsonArray jsonObjects) throws IOException {
        try (FileWriter writer = new FileWriter(this.currentFilePath.toFile());){
            GSON.toJson((JsonElement)jsonObjects, (Appendable)writer);
            writer.flush();
        }
    }

    public void reloadDatapacks() {
        try {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.f_108617_.m_246623_("reload");
                GlobalReplacementCache.rebuild();
                this.showMessage((Component)Component.m_237115_((String)"message.oneenoughitem.datapack_reload_triggered").m_130940_(ChatFormatting.GREEN));
                Oneenoughitem.LOGGER.info("Datapacks reloaded and global cache rebuilt");
            }
        }
        catch (Exception e) {
            this.showError((Component)Component.m_237110_((String)"error.oneenoughitem.reload_failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED));
            Oneenoughitem.LOGGER.error("Failed to reload datapacks", (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface RunnableWithException {
        public void run() throws Exception;
    }

    private record ValidationResult(boolean isValid, Component errorMessage) {
    }

    private record ReplacementData(List<String> matchItemsList, List<String> matchTagsList, String resultItemString) {
    }
}

