/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.components;

import com.mafuyu404.oneenoughitem.client.gui.components.ItemDisplayWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class ScrollablePanel
extends AbstractWidget {
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    private int scrollOffset = 0;
    private int contentHeight = 0;
    private int maxVisibleHeight;
    private boolean isDragging = false;
    private final int scrollbarWidth = 6;
    private int scrollbarHeight = 0;
    private int scrollbarY = 0;

    public ScrollablePanel(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.maxVisibleHeight = height;
    }

    public void addWidget(AbstractWidget widget) {
        this.widgets.add(widget);
        this.updateContentHeight();
    }

    public void clearWidgets() {
        this.widgets.clear();
        this.scrollOffset = 0;
        this.contentHeight = 0;
    }

    private void updateContentHeight() {
        int maxY = 0;
        for (AbstractWidget widget : this.widgets) {
            int relativeY = widget.m_252907_() + widget.m_93694_() - this.m_252907_();
            maxY = Math.max(maxY, relativeY);
        }
        this.contentHeight = maxY;
        this.scrollbarHeight = this.contentHeight > this.maxVisibleHeight ? Math.max(20, this.maxVisibleHeight * this.maxVisibleHeight / this.contentHeight) : 0;
        int maxScroll = Math.max(0, this.contentHeight - this.maxVisibleHeight);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, maxScroll));
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280588_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.maxVisibleHeight);
        AbstractWidget hoveredChild = null;
        for (AbstractWidget widget : this.widgets) {
            int widgetY = widget.m_252907_() - this.scrollOffset;
            if (widgetY + widget.m_93694_() < this.m_252907_() || widgetY > this.m_252907_() + this.maxVisibleHeight) continue;
            int originalY = widget.m_252907_();
            widget.m_253211_(widgetY);
            widget.m_88315_(graphics, mouseX, mouseY, partialTick);
            if (mouseY >= widgetY && mouseY <= widgetY + widget.m_93694_() && mouseX >= widget.m_252754_() && mouseX <= widget.m_252754_() + widget.m_5711_()) {
                hoveredChild = widget;
            }
            widget.m_253211_(originalY);
        }
        graphics.m_280618_();
        if (hoveredChild instanceof ItemDisplayWidget) {
            ItemDisplayWidget idw = (ItemDisplayWidget)hoveredChild;
            idw.renderTooltip(graphics, mouseX, mouseY);
        }
        if (this.contentHeight > this.maxVisibleHeight) {
            this.drawScrollbar(graphics);
        }
    }

    private void drawScrollbar(GuiGraphics graphics) {
        int scrollbarX = this.m_252754_() + this.f_93618_ - this.scrollbarWidth - 33;
        int trackHeight = this.maxVisibleHeight;
        graphics.m_280509_(scrollbarX, this.m_252907_(), scrollbarX + this.scrollbarWidth, this.m_252907_() + trackHeight, 0x30FFFFFF);
        int maxScroll = Math.max(0, this.contentHeight - this.maxVisibleHeight);
        if (maxScroll > 0) {
            float scrollRatio = (float)this.scrollOffset / (float)maxScroll;
            this.scrollbarY = this.m_252907_() + (int)(scrollRatio * (float)(trackHeight - this.scrollbarHeight));
            graphics.m_280509_(scrollbarX, this.scrollbarY, scrollbarX + this.scrollbarWidth, this.scrollbarY + this.scrollbarHeight, 0x50FFFFFF);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int scrollbarX;
        if (!this.m_274382_()) {
            return false;
        }
        if (this.contentHeight > this.maxVisibleHeight && mouseX >= (double)(scrollbarX = this.m_252754_() + this.f_93618_ - this.scrollbarWidth) && mouseX <= (double)(scrollbarX + this.scrollbarWidth) && mouseY >= (double)this.scrollbarY && mouseY <= (double)(this.scrollbarY + this.scrollbarHeight)) {
            this.isDragging = true;
            return true;
        }
        for (AbstractWidget widget : this.widgets) {
            int widgetY = widget.m_252907_() - this.scrollOffset;
            if (!(mouseY >= (double)widgetY) || !(mouseY <= (double)(widgetY + widget.m_93694_())) || !(mouseX >= (double)widget.m_252754_()) || !(mouseX <= (double)(widget.m_252754_() + widget.m_5711_()))) continue;
            int originalY = widget.m_252907_();
            widget.m_253211_(widgetY);
            boolean result = widget.m_6375_(mouseX, mouseY, button);
            widget.m_253211_(originalY);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        for (AbstractWidget widget : this.widgets) {
            int widgetY = widget.m_252907_() - this.scrollOffset;
            if (!(mouseY >= (double)widgetY) || !(mouseY <= (double)(widgetY + widget.m_93694_())) || !(mouseX >= (double)widget.m_252754_()) || !(mouseX <= (double)(widget.m_252754_() + widget.m_5711_()))) continue;
            int originalY = widget.m_252907_();
            widget.m_253211_(widgetY);
            boolean result = widget.m_6348_(mouseX, mouseY, button);
            widget.m_253211_(originalY);
            if (!result) continue;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging && this.contentHeight > this.maxVisibleHeight) {
            int trackHeight = this.maxVisibleHeight - this.scrollbarHeight;
            int maxScroll = Math.max(0, this.contentHeight - this.maxVisibleHeight);
            double scrollRatio = (mouseY - (double)this.m_252907_()) / (double)trackHeight;
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)maxScroll, scrollRatio * (double)maxScroll));
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.m_274382_() && this.contentHeight > this.maxVisibleHeight) {
            int maxScroll = Math.max(0, this.contentHeight - this.maxVisibleHeight);
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)maxScroll, (double)this.scrollOffset - delta * 10.0));
            return true;
        }
        return false;
    }

    public void updateWidgetPositions() {
        this.updateContentHeight();
    }

    public void setVisibleHeight(int height) {
        this.f_93619_ = this.maxVisibleHeight = Math.max(0, height);
        this.updateContentHeight();
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237113_((String)"Scrollable Panel"));
    }
}

