/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.components;

import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.client.gui.util.ReplacementUtils;
import com.mafuyu404.oneenoughitem.init.ReplacementControl;
import com.mafuyu404.oneenoughitem.init.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemGridWidget
extends AbstractWidget {
    private final int gridWidth;
    private final int gridHeight;
    private final Consumer<ItemStack> onItemClick;
    private List<ItemStack> items = new ArrayList<ItemStack>();
    private int hoveredIndex = -1;
    private Set<String> selectedItemIds = Collections.emptySet();

    public ItemGridWidget(int x, int y, int gridWidth, int gridHeight, Consumer<ItemStack> onItemClick) {
        super(x, y, gridWidth * 18, gridHeight * 18, (Component)Component.m_237119_());
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.onItemClick = onItemClick;
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.hoveredIndex = -1;
        for (int i = 0; i < this.items.size() && i < this.gridWidth * 18 / 18 * this.gridHeight; ++i) {
            int row = i / this.gridWidth;
            int col = i % this.gridWidth;
            int itemX = this.m_252754_() + col * 18;
            int itemY = this.m_252907_() + row * 18;
            GuiUtils.drawItemBox(graphics, itemX, itemY, 18, 18);
            ItemStack itemStack = this.items.get(i);
            ReplacementControl.withSkipReplacement(() -> {
                graphics.m_280480_(itemStack, itemX + 1, itemY + 1);
                graphics.m_280370_(Minecraft.m_91087_().f_91062_, itemStack, itemX + 1, itemY + 1);
            });
            String itemId = Utils.getItemRegistryName(itemStack.m_41720_());
            ReplacementUtils.ReplacementInfo replacementInfo = ReplacementUtils.getReplacementInfo(itemId);
            if (replacementInfo.isReplaced()) {
                ReplacementUtils.ReplacementIndicator.renderItemReplaced(graphics, itemX + 12, itemY + 1);
            } else if (replacementInfo.isUsedAsResult()) {
                ReplacementUtils.ReplacementIndicator.renderItemUsedAsResult(graphics, itemX + 12, itemY + 1);
            }
            if (itemId != null && this.selectedItemIds.contains(itemId)) {
                graphics.m_280509_(itemX + 1, itemY + 1, itemX + 17, itemY + 17, -2144097537);
            }
            if (mouseX < itemX || mouseX >= itemX + 18 || mouseY < itemY || mouseY >= itemY + 18) continue;
            graphics.m_280509_(itemX + 1, itemY + 1, itemX + 17, itemY + 17, -2130706433);
            this.hoveredIndex = i;
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ItemStack hoveredStack;
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.hoveredIndex >= 0 && this.hoveredIndex < this.items.size() && (hoveredStack = this.items.get(this.hoveredIndex)) != null && !hoveredStack.m_41619_()) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            ReplacementControl.withSkipReplacement(() -> tooltip.add(hoveredStack.m_41786_()));
            String itemId = Utils.getItemRegistryName(hoveredStack.m_41720_());
            if (itemId != null) {
                ReplacementUtils.ReplacementInfo replacementInfo = ReplacementUtils.getReplacementInfo(itemId);
                replacementInfo.addToTooltip(tooltip);
            }
            String modId = ForgeRegistries.ITEMS.getKey((Object)hoveredStack.m_41720_()).m_135827_();
            tooltip.add((Component)Component.m_237113_((String)modId).m_130940_(ChatFormatting.BLUE));
            graphics.m_280666_(Minecraft.m_91087_().f_91062_, tooltip, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_274382_()) {
            int col;
            int relativeX = (int)(mouseX - (double)this.m_252754_());
            int relativeY = (int)(mouseY - (double)this.m_252907_());
            int row = relativeY / 18;
            int index = row * this.gridWidth + (col = relativeX / 18);
            if (index >= 0 && index < this.items.size()) {
                this.onItemClick.accept(this.items.get(index));
                return true;
            }
        }
        return false;
    }

    public void setItems(List<ItemStack> items) {
        this.items = new ArrayList<ItemStack>(items);
    }

    public void setSelectedItemIds(Set<String> selectedItemIds) {
        this.selectedItemIds = selectedItemIds != null ? selectedItemIds : Collections.emptySet();
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237113_((String)"Item Grid"));
    }
}

