/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.components;

import com.mafuyu404.oneenoughitem.init.ReplacementControl;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemDisplayWidget
extends AbstractWidget {
    private final ItemStack itemStack;
    private final Button.OnPress removeAction;
    private final String originalItemId;
    private final boolean skipReplacement;
    private static final ResourceLocation ITEM_BOX_TEX = new ResourceLocation("oneenoughitem", "textures/gui/item_box.png");
    private static final ResourceLocation CROSS_TEX = new ResourceLocation("oneenoughitem", "textures/gui/cross.png");

    public ItemDisplayWidget(int x, int y, ItemStack itemStack, Button.OnPress removeAction) {
        this(x, y, itemStack, removeAction, null, false);
    }

    public ItemDisplayWidget(int x, int y, ItemStack itemStack, Button.OnPress removeAction, String originalItemId, boolean skipReplacement) {
        super(x, y, 18, 18, (Component)Component.m_237119_());
        this.itemStack = itemStack;
        this.removeAction = removeAction;
        this.originalItemId = originalItemId;
        this.skipReplacement = skipReplacement;
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280163_(ITEM_BOX_TEX, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, 18, 18);
        if (!this.itemStack.m_41619_()) {
            if (this.skipReplacement) {
                ReplacementControl.withSkipReplacement(() -> {
                    graphics.m_280480_(this.itemStack, this.m_252754_() + 1, this.m_252907_() + 1);
                    graphics.m_280370_(Minecraft.m_91087_().f_91062_, this.itemStack, this.m_252754_() + 1, this.m_252907_() + 1);
                });
            } else {
                graphics.m_280480_(this.itemStack, this.m_252754_() + 1, this.m_252907_() + 1);
                graphics.m_280370_(Minecraft.m_91087_().f_91062_, this.itemStack, this.m_252754_() + 1, this.m_252907_() + 1);
            }
        }
        if (this.m_274382_() && this.removeAction != null) {
            int crossX = this.m_252754_() + this.f_93618_ - 9;
            int crossY = this.m_252907_() + 1;
            graphics.m_280163_(CROSS_TEX, crossX, crossY, 0.0f, 0.0f, 8, 8, 8, 8);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.m_274382_() && !this.itemStack.m_41619_()) {
            this.renderToolTip(graphics, mouseX, mouseY);
        }
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.m_274382_() || this.itemStack.m_41619_()) {
            return;
        }
        this.renderToolTip(graphics, mouseX, mouseY);
    }

    private void renderToolTip(GuiGraphics graphics, int mouseX, int mouseY) {
        ArrayList<Object> lines = new ArrayList<Object>();
        if (this.skipReplacement) {
            ReplacementControl.withSkipReplacement(() -> lines.add(this.itemStack.m_41786_()));
        } else {
            lines.add(this.itemStack.m_41786_());
        }
        String modId = ForgeRegistries.ITEMS.getKey((Object)this.itemStack.m_41720_()).m_135827_();
        String modName = ModList.get().getModContainerById(modId).map(c -> c.getModInfo().getDisplayName()).orElse(modId);
        lines.add(Component.m_237113_((String)modName).m_130940_(ChatFormatting.BLUE));
        graphics.m_280666_(Minecraft.m_91087_().f_91062_, lines, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_274382_() && this.removeAction != null) {
            int crossX = this.m_252754_() + this.f_93618_ - 9;
            int crossY = this.m_252907_() + 1;
            if (mouseX >= (double)crossX && mouseX <= (double)(crossX + 8) && mouseY >= (double)crossY && mouseY <= (double)(crossY + 8)) {
                this.removeAction.m_93750_(null);
                return true;
            }
        }
        return false;
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    public String getOriginalItemId() {
        return this.originalItemId;
    }

    public void m_264152_(int x, int y) {
        this.m_252865_(x);
        this.m_253211_(y);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, this.itemStack.m_41786_());
    }
}

