/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.cache;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.client.gui.cache.BaseCache;
import com.mafuyu404.oneenoughitem.client.gui.util.PathUtils;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.Utils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class GlobalReplacementCache
extends BaseCache {
    private static final GlobalReplacementCache INSTANCE = new GlobalReplacementCache();
    private final Map<String, String> replacedItems = new ConcurrentHashMap<String, String>();
    private final Map<String, String> replacedTags = new ConcurrentHashMap<String, String>();
    private final Map<String, String> resultItems = new ConcurrentHashMap<String, String>();
    private final Map<String, String> resultTags = new ConcurrentHashMap<String, String>();

    private GlobalReplacementCache() {
        super("global_replacement_cache.dat", 1);
    }

    @Override
    protected void onInitialized() {
        Oneenoughitem.LOGGER.info("Global replacement cache initialized with {} items and {} tags", (Object)this.replacedItems.size(), (Object)this.replacedTags.size());
    }

    @Override
    protected void onVersionMismatch(int foundVersion) {
        Oneenoughitem.LOGGER.warn("Global replacement cache version mismatch, rebuilding cache");
        GlobalReplacementCache.rebuild();
    }

    @Override
    protected void onLoadError(IOException e) {
        this.clearAllMaps();
    }

    @Override
    protected void loadData(DataInputStream dis) throws IOException {
        GlobalReplacementCache.readStringMap(dis, this.replacedItems);
        GlobalReplacementCache.readStringMap(dis, this.replacedTags);
        try {
            GlobalReplacementCache.readStringMap(dis, this.resultItems);
            GlobalReplacementCache.readStringMap(dis, this.resultTags);
        }
        catch (IOException e) {
            Oneenoughitem.LOGGER.info("Old cache format detected, rebuilding to include result tracking");
            GlobalReplacementCache.rebuild();
        }
    }

    @Override
    protected void saveData(DataOutputStream dos) throws IOException {
        GlobalReplacementCache.writeStringMap(dos, this.replacedItems);
        GlobalReplacementCache.writeStringMap(dos, this.replacedTags);
        GlobalReplacementCache.writeStringMap(dos, this.resultItems);
        GlobalReplacementCache.writeStringMap(dos, this.resultTags);
    }

    public static void addReplacement(Collection<String> matchItems, Collection<String> matchTags, String resultItem, String resultTag, String sourceFile) {
        INSTANCE.withInitializedWriteLock(() -> {
            String result;
            String string = result = resultItem != null ? resultItem : resultTag;
            if (result == null) {
                Oneenoughitem.LOGGER.warn("Cannot add replacement with null result from file: {}", (Object)sourceFile);
                return;
            }
            GlobalReplacementCache.processValidStrings(matchItems, itemId -> GlobalReplacementCache.INSTANCE.replacedItems.put((String)itemId, result));
            GlobalReplacementCache.processValidStrings(matchTags, tagId -> GlobalReplacementCache.INSTANCE.replacedTags.put((String)tagId, result));
            GlobalReplacementCache.addToResultMap(resultItem, sourceFile, GlobalReplacementCache.INSTANCE.resultItems);
            GlobalReplacementCache.addToResultMap(resultTag, sourceFile, GlobalReplacementCache.INSTANCE.resultTags);
            INSTANCE.saveToFileAsync();
        });
    }

    public static void removeReplacement(Collection<String> matchItems, Collection<String> matchTags) {
        INSTANCE.withInitializedWriteLock(() -> {
            boolean changed = false;
            changed |= GlobalReplacementCache.removeFromReplacementMap(matchItems, GlobalReplacementCache.INSTANCE.replacedItems, "item");
            if (changed |= GlobalReplacementCache.removeFromReplacementMap(matchTags, GlobalReplacementCache.INSTANCE.replacedTags, "tag")) {
                INSTANCE.saveToFileAsync();
                Oneenoughitem.LOGGER.debug("Global replacement cache updated after removal");
            }
        });
    }

    public static boolean isItemReplaced(Item item) {
        if (item == null) {
            return false;
        }
        String itemId = Utils.getItemRegistryName(item);
        return GlobalReplacementCache.isItemReplaced(itemId);
    }

    public static boolean isItemReplaced(String itemId) {
        return INSTANCE.withInitializedReadLock(() -> GlobalReplacementCache.isValidString(itemId) && GlobalReplacementCache.INSTANCE.replacedItems.containsKey(itemId));
    }

    public static boolean isTagReplaced(ResourceLocation tagId) {
        return tagId != null && GlobalReplacementCache.isTagReplaced(tagId.toString());
    }

    public static boolean isTagReplaced(String tagId) {
        return INSTANCE.withInitializedReadLock(() -> GlobalReplacementCache.isValidString(tagId) && GlobalReplacementCache.INSTANCE.replacedTags.containsKey(tagId));
    }

    public static String getItemReplacement(String itemId) {
        return INSTANCE.withInitializedReadLock(() -> GlobalReplacementCache.isValidString(itemId) ? GlobalReplacementCache.INSTANCE.replacedItems.get(itemId) : null);
    }

    public static String getTagReplacement(String tagId) {
        return INSTANCE.withInitializedReadLock(() -> GlobalReplacementCache.isValidString(tagId) ? GlobalReplacementCache.INSTANCE.replacedTags.get(tagId) : null);
    }

    public static boolean isItemUsedAsResult(String itemId) {
        return INSTANCE.withInitializedReadLock(() -> GlobalReplacementCache.isValidString(itemId) && GlobalReplacementCache.INSTANCE.resultItems.containsKey(itemId));
    }

    public static Set<String> getAllReplacedItems() {
        return INSTANCE.withInitializedReadLock(() -> new HashSet<String>(GlobalReplacementCache.INSTANCE.replacedItems.keySet()));
    }

    public static Set<String> getAllReplacedTags() {
        return INSTANCE.withInitializedReadLock(() -> new HashSet<String>(GlobalReplacementCache.INSTANCE.replacedTags.keySet()));
    }

    public static boolean isTagUsedAsResult(String tagId) {
        return INSTANCE.withInitializedReadLock(() -> GlobalReplacementCache.isValidString(tagId) && GlobalReplacementCache.INSTANCE.resultTags.containsKey(tagId));
    }

    public static void clearAll() {
        INSTANCE.withInitializedWriteLock(() -> {
            INSTANCE.clearAllMaps();
            INSTANCE.saveToFileAsync();
            Oneenoughitem.LOGGER.info("Global replacement cache cleared");
        });
    }

    public static void rebuild() {
        INSTANCE.withInitializedWriteLock(() -> {
            Oneenoughitem.LOGGER.info("Starting global replacement cache rebuild...");
            int oldItemCount = GlobalReplacementCache.INSTANCE.replacedItems.size();
            int oldTagCount = GlobalReplacementCache.INSTANCE.replacedTags.size();
            INSTANCE.clearAllMaps();
            GlobalReplacementCache.rebuildFromJsonFiles();
            INSTANCE.saveToFileAsync();
            Oneenoughitem.LOGGER.info("Global replacement cache rebuilt: {} -> {} items, {} -> {} tags", (Object)oldItemCount, (Object)GlobalReplacementCache.INSTANCE.replacedItems.size(), (Object)oldTagCount, (Object)GlobalReplacementCache.INSTANCE.replacedTags.size());
        });
    }

    public static String getStats() {
        return INSTANCE.withInitializedReadLock(() -> String.format("Items: %d, Tags: %d, Result Items: %d, Result Tags: %d", GlobalReplacementCache.INSTANCE.replacedItems.size(), GlobalReplacementCache.INSTANCE.replacedTags.size(), GlobalReplacementCache.INSTANCE.resultItems.size(), GlobalReplacementCache.INSTANCE.resultTags.size()));
    }

    private static void readStringMap(DataInputStream dis, Map<String, String> map) throws IOException {
        int count = dis.readInt();
        for (int i = 0; i < count; ++i) {
            String key = dis.readUTF();
            String value = dis.readUTF();
            if (!GlobalReplacementCache.isValidString(key) || !GlobalReplacementCache.isValidString(value)) continue;
            map.put(key, value);
        }
    }

    private static void writeStringMap(DataOutputStream dos, Map<String, String> map) throws IOException {
        dos.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            dos.writeUTF(entry.getKey());
            dos.writeUTF(entry.getValue());
        }
    }

    private static boolean isValidString(String str) {
        return str != null && !str.isEmpty();
    }

    private static boolean isTag(String str) {
        return str != null && str.startsWith("#");
    }

    private static String removeTagPrefix(String tag) {
        return GlobalReplacementCache.isTag(tag) ? tag.substring(1) : tag;
    }

    private static void processValidStrings(Collection<String> strings, Consumer<String> processor) {
        if (strings != null) {
            strings.stream().filter(GlobalReplacementCache::isValidString).forEach(processor);
        }
    }

    private static void addToResultMap(String item, String source, Map<String, String> resultMap) {
        if (GlobalReplacementCache.isValidString(item)) {
            resultMap.put(item, source);
        }
    }

    private static boolean removeFromReplacementMap(Collection<String> items, Map<String, String> replacementMap, String itemType) {
        boolean changed = false;
        if (items != null) {
            for (String item : items) {
                String removedResult;
                if (!GlobalReplacementCache.isValidString(item) || (removedResult = replacementMap.remove(item)) == null) continue;
                changed = true;
                Oneenoughitem.LOGGER.debug("Removed {} replacement: {}", (Object)itemType, (Object)item);
                GlobalReplacementCache.removeFromResultMaps(removedResult);
            }
        }
        return changed;
    }

    private static void removeFromResultMaps(String result) {
        if (GlobalReplacementCache.isTag(result)) {
            GlobalReplacementCache.INSTANCE.resultTags.remove(GlobalReplacementCache.removeTagPrefix(result));
        } else {
            GlobalReplacementCache.INSTANCE.resultItems.remove(result);
        }
    }

    private void clearAllMaps() {
        this.replacedItems.clear();
        this.replacedTags.clear();
        this.resultItems.clear();
        this.resultTags.clear();
    }

    private <T> T withInitializedReadLock(Supplier<T> operation) {
        this.initialize();
        return this.withReadLock(operation);
    }

    private void withInitializedWriteLock(Runnable operation) {
        this.initialize();
        this.withWriteLock(operation);
    }

    private static void rebuildFromJsonFiles() {
        try {
            List<PathUtils.FileInfo> fileInfos = PathUtils.scanAllReplacementFiles();
            fileInfos.forEach(GlobalReplacementCache::processReplacementFile);
            Oneenoughitem.LOGGER.info("Rebuilt global replacement cache from {} files: {} items, {} tags, {} result items, {} result tags", (Object)fileInfos.size(), (Object)GlobalReplacementCache.INSTANCE.replacedItems.size(), (Object)GlobalReplacementCache.INSTANCE.replacedTags.size(), (Object)GlobalReplacementCache.INSTANCE.resultItems.size(), (Object)GlobalReplacementCache.INSTANCE.resultTags.size());
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.error("Failed to rebuild global replacement cache from JSON files", (Throwable)e);
        }
    }

    private static void processReplacementFile(PathUtils.FileInfo fileInfo) {
        try {
            String content = Files.readString(fileInfo.filePath());
            if (content.trim().isEmpty()) {
                Oneenoughitem.LOGGER.debug("Skipping empty file: {}", (Object)fileInfo.filePath());
                return;
            }
            JsonElement parsed = (JsonElement)new Gson().fromJson(content, JsonElement.class);
            if (parsed != null && parsed.isJsonArray()) {
                JsonArray jsonArray = parsed.getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    GlobalReplacementCache.processReplacementElement(element, fileInfo);
                }
            }
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("Failed to read replacement file: {}", (Object)fileInfo.filePath(), (Object)e);
        }
    }

    private static void processReplacementElement(JsonElement element, PathUtils.FileInfo fileInfo) {
        try {
            DataResult result = Replacements.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (result.result().isPresent()) {
                Replacements replacement = (Replacements)result.result().get();
                String resultString = replacement.resultItems();
                for (String matchItem : replacement.matchItems()) {
                    if (GlobalReplacementCache.isTag(matchItem)) {
                        GlobalReplacementCache.INSTANCE.replacedTags.put(GlobalReplacementCache.removeTagPrefix(matchItem), resultString);
                        continue;
                    }
                    GlobalReplacementCache.INSTANCE.replacedItems.put(matchItem, resultString);
                }
                if (GlobalReplacementCache.isTag(resultString)) {
                    GlobalReplacementCache.INSTANCE.resultTags.put(GlobalReplacementCache.removeTagPrefix(resultString), fileInfo.filePath().toString());
                } else {
                    GlobalReplacementCache.INSTANCE.resultItems.put(resultString, fileInfo.filePath().toString());
                }
            }
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("Failed to parse replacement rule in file: {}", (Object)fileInfo.filePath(), (Object)e);
        }
    }
}

