/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.cache;

import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.client.gui.cache.BaseCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class EditorCache
extends BaseCache {
    private static final EditorCache INSTANCE = new EditorCache();

    private EditorCache() {
        super("editor_cache.dat", 1);
    }

    @Override
    protected void onInitialized() {
    }

    @Override
    protected void onVersionMismatch(int foundVersion) {
        Oneenoughitem.LOGGER.warn("Editor cache version mismatch, ignoring cache");
    }

    @Override
    protected void onLoadError(IOException e) {
    }

    @Override
    protected void loadData(DataInputStream dis) throws IOException {
        throw new UnsupportedOperationException("Use loadCache() method instead");
    }

    @Override
    protected void saveData(DataOutputStream dos) throws IOException {
        throw new UnsupportedOperationException("Use saveCache() method instead");
    }

    public static void saveCache(Set<Item> matchItems, Set<ResourceLocation> matchTags, Item resultItem, ResourceLocation resultTag, String fileName) {
        INSTANCE.withWriteLock(() -> {
            try {
                INSTANCE.saveToFile(matchItems, matchTags, resultItem, resultTag, fileName);
            }
            catch (Exception e) {
                Oneenoughitem.LOGGER.error("Failed to save editor cache", (Throwable)e);
            }
        });
    }

    private void saveToFile(Set<Item> matchItems, Set<ResourceLocation> matchTags, Item resultItem, ResourceLocation resultTag, String fileName) {
        try {
            Files.createDirectories(this.cacheFile.getParent(), new FileAttribute[0]);
            Path tempFile = this.cacheFile.resolveSibling(String.valueOf(this.cacheFile.getFileName()) + ".tmp");
            if (Files.exists(tempFile, new LinkOption[0])) {
                Files.delete(tempFile);
            }
            try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(tempFile, new OpenOption[0])));){
                dos.writeInt(this.cacheVersion);
                dos.writeInt(matchItems.size());
                for (Item item : matchItems) {
                    ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
                    dos.writeUTF(id != null ? id.toString() : "");
                }
                dos.writeInt(matchTags.size());
                for (ResourceLocation tag : matchTags) {
                    dos.writeUTF(tag.toString());
                }
                if (resultItem != null) {
                    ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)resultItem);
                    dos.writeUTF(id != null ? id.toString() : "");
                } else {
                    dos.writeUTF("");
                }
                dos.writeUTF(resultTag != null ? resultTag.toString() : "");
                dos.writeUTF(fileName != null ? fileName : "");
                dos.flush();
            }
            Files.move(tempFile, this.cacheFile, StandardCopyOption.REPLACE_EXISTING);
            Oneenoughitem.LOGGER.debug("Editor cache saved successfully to: {}", (Object)this.cacheFile);
        }
        catch (IOException e) {
            Oneenoughitem.LOGGER.error("Failed to save editor cache to: {}", (Object)this.cacheFile, (Object)e);
        }
    }

    public static CacheData loadCache() {
        return INSTANCE.withReadLock(() -> {
            if (!Files.exists(EditorCache.INSTANCE.cacheFile, new LinkOption[0])) {
                Oneenoughitem.LOGGER.debug("Editor cache file not found: {}", (Object)EditorCache.INSTANCE.cacheFile);
                return null;
            }
            try (DataInputStream dis = new DataInputStream(new BufferedInputStream(Files.newInputStream(EditorCache.INSTANCE.cacheFile, new OpenOption[0])));){
                String fileName;
                String resultTag;
                int version = dis.readInt();
                if (version != EditorCache.INSTANCE.cacheVersion) {
                    Oneenoughitem.LOGGER.warn("Editor cache version mismatch, ignoring cache");
                    CacheData cacheData = null;
                    return cacheData;
                }
                Set<String> matchItems = EditorCache.readStringSet(dis);
                Set<String> matchTags = EditorCache.readStringSet(dis);
                String resultItem = dis.readUTF();
                if (resultItem.isEmpty()) {
                    resultItem = null;
                }
                if ((resultTag = dis.readUTF()).isEmpty()) {
                    resultTag = null;
                }
                if ((fileName = dis.readUTF()).isEmpty()) {
                    fileName = null;
                }
                Oneenoughitem.LOGGER.debug("Editor cache loaded successfully from: {}", (Object)EditorCache.INSTANCE.cacheFile);
                CacheData cacheData = new CacheData(matchItems, matchTags, resultItem, resultTag, fileName);
                return cacheData;
            }
            catch (IOException e) {
                Oneenoughitem.LOGGER.error("Failed to load editor cache from: {}", (Object)EditorCache.INSTANCE.cacheFile, (Object)e);
                return null;
            }
        });
    }

    private static Set<String> readStringSet(DataInputStream dis) throws IOException {
        HashSet<String> result = new HashSet<String>();
        int count = dis.readInt();
        for (int i = 0; i < count; ++i) {
            String str = dis.readUTF();
            if (str.isEmpty()) continue;
            result.add(str);
        }
        return result;
    }

    public static void clearCache() {
        INSTANCE.clearCacheFile();
    }

    @Override
    public Path getCacheFilePath() {
        return EditorCache.INSTANCE.cacheFile;
    }

    public record CacheData(Set<String> matchItems, Set<String> matchTags, String resultItem, String resultTag, String fileName) {
    }
}

