/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.cache;

import com.mafuyu404.oneenoughitem.Oneenoughitem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public abstract class BaseCache {
    protected static final Path OEI_DIR = Paths.get("oei", new String[0]);
    protected final Path cacheFile;
    protected final int cacheVersion;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected volatile boolean initialized = false;

    protected BaseCache(String fileName, int version) {
        this.cacheFile = OEI_DIR.resolve(fileName);
        this.cacheVersion = version;
    }

    protected void initialize() {
        if (this.initialized) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (this.initialized) {
                return;
            }
            this.loadFromFile();
            this.initialized = true;
            this.onInitialized();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected abstract void onInitialized();

    protected void loadFromFile() {
        if (!Files.exists(this.cacheFile, new LinkOption[0])) {
            Oneenoughitem.LOGGER.debug("Cache file not found: {}, starting with empty cache", (Object)this.cacheFile);
            return;
        }
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(Files.newInputStream(this.cacheFile, new OpenOption[0])));){
            int version = dis.readInt();
            if (version != this.cacheVersion) {
                Oneenoughitem.LOGGER.warn("Cache version mismatch for {}, expected {}, got {}", (Object)this.cacheFile, (Object)this.cacheVersion, (Object)version);
                this.onVersionMismatch(version);
                return;
            }
            this.loadData(dis);
            Oneenoughitem.LOGGER.debug("Loaded cache from: {}", (Object)this.cacheFile);
        }
        catch (IOException e) {
            Oneenoughitem.LOGGER.error("Failed to load cache from: {}", (Object)this.cacheFile, (Object)e);
            this.onLoadError(e);
        }
    }

    protected abstract void onVersionMismatch(int var1);

    protected abstract void onLoadError(IOException var1);

    protected abstract void loadData(DataInputStream var1) throws IOException;

    protected void saveToFileAsync() {
        Thread saveThread = new Thread(() -> {
            try {
                this.saveToFile();
            }
            catch (Exception e) {
                Oneenoughitem.LOGGER.error("Failed to save cache asynchronously: {}", (Object)this.cacheFile, (Object)e);
            }
        });
        saveThread.setDaemon(true);
        saveThread.setName(this.getClass().getSimpleName() + "-Save");
        saveThread.start();
    }

    protected void saveToFile() {
        try {
            Files.createDirectories(this.cacheFile.getParent(), new FileAttribute[0]);
            Path tempFile = this.cacheFile.resolveSibling(String.valueOf(this.cacheFile.getFileName()) + ".tmp");
            if (Files.exists(tempFile, new LinkOption[0])) {
                Files.delete(tempFile);
            }
            try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(tempFile, new OpenOption[0])));){
                dos.writeInt(this.cacheVersion);
                this.saveData(dos);
                dos.flush();
            }
            Files.move(tempFile, this.cacheFile, StandardCopyOption.REPLACE_EXISTING);
            Oneenoughitem.LOGGER.debug("Saved cache to: {}", (Object)this.cacheFile);
        }
        catch (IOException e) {
            Oneenoughitem.LOGGER.error("Failed to save cache to: {}", (Object)this.cacheFile, (Object)e);
        }
    }

    protected abstract void saveData(DataOutputStream var1) throws IOException;

    protected void clearCacheFile() {
        try {
            if (Files.exists(this.cacheFile, new LinkOption[0])) {
                Files.delete(this.cacheFile);
                Oneenoughitem.LOGGER.debug("Cache file cleared: {}", (Object)this.cacheFile);
            }
        }
        catch (IOException e) {
            Oneenoughitem.LOGGER.error("Failed to clear cache file: {}", (Object)this.cacheFile, (Object)e);
        }
    }

    public Path getCacheFilePath() {
        return this.cacheFile;
    }

    protected <T> T withReadLock(Supplier<T> operation) {
        this.lock.readLock().lock();
        try {
            T t = operation.get();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void withWriteLock(Runnable operation) {
        this.lock.writeLock().lock();
        try {
            operation.run();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected <T> T withWriteLock(Supplier<T> operation) {
        this.lock.writeLock().lock();
        try {
            T t = operation.get();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

