/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui;

import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.components.TagListWidget;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.ForgeRegistries;

public class TagSelectionScreen
extends Screen {
    private final ReplacementEditorScreen parent;
    private final boolean isForMatch;
    private EditBox searchBox;
    private Button backButton;
    private TagListWidget tagList;
    private List<ResourceLocation> allTags;
    private List<ResourceLocation> filteredTags;
    private final Set<ResourceLocation> selectedTags = new HashSet<ResourceLocation>();
    private Button confirmSelectionButton;
    private Button clearSelectionButton;
    private int lastSearchLength = 0;

    public TagSelectionScreen(ReplacementEditorScreen parent, boolean isForMatch) {
        super((Component)Component.m_237115_((String)"gui.oneenoughitem.tag_selection.title"));
        this.parent = parent;
        this.isForMatch = isForMatch;
        this.initializeTags();
    }

    private void initializeTags() {
        this.allTags = ForgeRegistries.ITEMS.tags().getTagNames().map(TagKey::f_203868_).sorted(Comparator.comparing(ResourceLocation::toString)).collect(Collectors.toList());
        this.filteredTags = new ArrayList<ResourceLocation>(this.allTags);
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        this.searchBox = new EditBox(this.f_96547_, centerX - 80, 15, 160, 18, (Component)Component.m_237115_((String)"gui.oneenoughitem.search"));
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"gui.oneenoughitem.search_tags.hint"));
        this.m_142416_((GuiEventListener)this.searchBox);
        this.tagList = new TagListWidget(this.f_96541_, this.f_96543_ - 40, this.f_96544_ - 100, 40, 22, this::selectTag);
        this.tagList.m_93507_(20);
        this.tagList.setSelectedTags(this.selectedTags);
        this.m_142416_((GuiEventListener)this.tagList);
        if (this.isForMatch) {
            int buttonY = this.f_96544_ - 50;
            int totalWidth = 290;
            int startX = centerX - totalWidth / 2;
            this.confirmSelectionButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.add_selected"), btn -> this.confirmSelectedTags(), startX, buttonY, 100, 18);
            this.m_142416_((GuiEventListener)this.confirmSelectionButton);
            this.backButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.back"), btn -> this.m_7379_(), startX + 100 + 10, buttonY, 80, 18);
            this.m_142416_((GuiEventListener)this.backButton);
            this.clearSelectionButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.clear_selected"), btn -> {
                this.selectedTags.clear();
                this.updateTagList();
                this.updateConfirmButtonsVisibility();
            }, startX + 100 + 10 + 80 + 10, buttonY, 100, 18);
            this.m_142416_((GuiEventListener)this.clearSelectionButton);
            this.updateConfirmButtonsVisibility();
        } else {
            this.backButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.back"), btn -> this.m_7379_(), centerX - 40, this.f_96544_ - 50, 80, 18);
            this.m_142416_((GuiEventListener)this.backButton);
        }
        this.updateTagList();
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.searchBox.m_94155_().length() != this.getLastSearchLength()) {
            this.filterTags();
            this.updateTagList();
        }
    }

    private int getLastSearchLength() {
        int current = this.lastSearchLength;
        this.lastSearchLength = this.searchBox.m_94155_().length();
        return current;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int panelX = 20;
        int panelY = 40;
        int panelW = this.f_96543_ - 40;
        int panelH = this.f_96544_ - 100;
        GuiUtils.drawPanelBackground(graphics, panelX, panelY, panelW, panelH);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        String tagCount = this.filteredTags.size() + " tags";
        graphics.m_280488_(this.f_96547_, tagCount, 10, this.f_96544_ - 30, 0xFFFFFF);
        TagListWidget.TagEntry hoveredEntry = this.tagList.getEntryAtMouse(mouseX, mouseY);
        if (hoveredEntry != null) {
            List<Component> tooltip = hoveredEntry.getTooltip();
            graphics.m_280666_(Minecraft.m_91087_().f_91062_, tooltip, mouseX, mouseY);
        }
    }

    private void filterTags() {
        String search = this.searchBox.m_94155_().toLowerCase();
        this.filteredTags = search.isEmpty() ? new ArrayList<ResourceLocation>(this.allTags) : this.allTags.stream().filter(tag -> tag.toString().toLowerCase().contains(search)).collect(Collectors.toList());
    }

    private void updateTagList() {
        this.tagList.setTags(this.filteredTags);
    }

    private void selectTag(ResourceLocation tagId) {
        if (this.isForMatch && TagSelectionScreen.m_96637_()) {
            if (this.selectedTags.contains(tagId)) {
                this.selectedTags.remove(tagId);
            } else {
                this.selectedTags.add(tagId);
            }
            this.updateTagList();
            this.updateConfirmButtonsVisibility();
            return;
        }
        if (this.isForMatch) {
            this.parent.addMatchTag(tagId);
        } else {
            this.parent.setResultTag(tagId);
        }
        this.m_7379_();
    }

    private void confirmSelectedTags() {
        if (!this.isForMatch || this.selectedTags.isEmpty()) {
            return;
        }
        int added = 0;
        for (ResourceLocation tagId : new ArrayList<ResourceLocation>(this.selectedTags)) {
            this.parent.addMatchTag(tagId);
            ++added;
        }
        this.selectedTags.clear();
        this.updateTagList();
        this.updateConfirmButtonsVisibility();
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)"message.oneenoughitem.multi_add_tags_result", (Object[])new Object[]{added}).m_130940_(ChatFormatting.GREEN), false);
        }
        this.m_7379_();
    }

    private void updateConfirmButtonsVisibility() {
        boolean hasSelection;
        if (!this.isForMatch) {
            return;
        }
        boolean bl = hasSelection = !this.selectedTags.isEmpty();
        if (this.confirmSelectionButton != null) {
            this.confirmSelectionButton.f_93623_ = hasSelection;
        }
        if (this.clearSelectionButton != null) {
            this.clearSelectionButton.f_93623_ = hasSelection;
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.parent);
    }
}

