/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui;

import com.mafuyu404.oneenoughitem.client.gui.ItemSelectionScreen;
import com.mafuyu404.oneenoughitem.client.gui.TagSelectionScreen;
import com.mafuyu404.oneenoughitem.client.gui.cache.EditorCache;
import com.mafuyu404.oneenoughitem.client.gui.cache.GlobalReplacementCache;
import com.mafuyu404.oneenoughitem.client.gui.components.ItemDisplayWidget;
import com.mafuyu404.oneenoughitem.client.gui.components.ScrollablePanel;
import com.mafuyu404.oneenoughitem.client.gui.components.TagDisplayWidget;
import com.mafuyu404.oneenoughitem.client.gui.editor.FileActions;
import com.mafuyu404.oneenoughitem.client.gui.editor.ItemsController;
import com.mafuyu404.oneenoughitem.client.gui.editor.ObjectDropdownController;
import com.mafuyu404.oneenoughitem.client.gui.editor.PanelsLayoutHelper;
import com.mafuyu404.oneenoughitem.client.gui.manager.ReplacementEditorManager;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.client.gui.util.ReplacementUtils;
import com.mafuyu404.oneenoughitem.init.ReplacementCache;
import com.mafuyu404.oneenoughitem.init.ReplacementControl;
import com.mafuyu404.oneenoughitem.init.Utils;
import com.mafuyu404.oneenoughitem.web.WebEditorServer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ReplacementEditorScreen
extends Screen {
    private static final int PANEL_WIDTH = 220;
    private static final int PANEL_HEIGHT = 140;
    private static final int BUTTON_WIDTH = 70;
    private static final int BUTTON_HEIGHT = 18;
    private static final int MARGIN = 8;
    private static final float EDITOR_SCALE_X = 1.24f;
    private static final float EDITOR_SCALE_Y = 2.255f;
    private static final int EDITOR_SHIFT_X = 5;
    private static final int EDITOR_SHIFT_Y = 0;
    private static final int EDITOR_INNER_MARGIN_X = 13;
    private static final int EDITOR_HEADER_GAP = 13;
    private static final int EDITOR_BOTTOM_MARGIN = 14;
    private final ReplacementEditorManager manager;
    private EditBox datapackNameBox;
    private EditBox fileNameBox;
    private Button createFileButton;
    private Button selectFileButton;
    private Button reloadButton;
    private Button clearAllButton;
    private Button saveToJSONButton;
    private Button openWebEditorButton;
    private Button objectDropdownButton;
    private boolean showObjectDropdown = false;
    private final List<Button> objectIndexButtons = new ArrayList<Button>();
    private ScrollablePanel objectDropdownPanel;
    private Button addMatchItemButton;
    private Button addMatchTagButton;
    private Button clearMatchButton;
    private ScrollablePanel matchPanel;
    private final List<ItemDisplayWidget> matchItemWidgets;
    private final List<TagDisplayWidget> matchTagWidgets;
    private Button selectResultItemButton;
    private Button clearResultButton;
    private ScrollablePanel resultPanel;
    private ItemDisplayWidget resultItemWidget;
    private TagDisplayWidget resultTagWidget;
    private final PanelsLayoutHelper panelsHelper = new PanelsLayoutHelper();
    private final FileActions fileActions;
    private final ItemsController itemsController;

    public ReplacementEditorScreen() {
        super((Component)Component.m_237115_((String)"gui.oneenoughitem.replacement_editor.title"));
        this.manager = new ReplacementEditorManager();
        this.matchItemWidgets = new ArrayList<ItemDisplayWidget>();
        this.matchTagWidgets = new ArrayList<TagDisplayWidget>();
        this.fileActions = new FileActions(this.manager);
        this.itemsController = new ItemsController(this.manager, this::syncManagerDataToWidgets);
        this.loadFromCache();
    }

    private void loadFromCache() {
        EditorCache.CacheData cache = EditorCache.loadCache();
        if (cache != null) {
            ResourceLocation id;
            Item item;
            ResourceLocation id2;
            for (String itemId : cache.matchItems()) {
                id2 = new ResourceLocation(itemId);
                Item item2 = (Item)ForgeRegistries.ITEMS.getValue(id2);
                if (item2 == null) continue;
                this.manager.addMatchItem(item2);
                ItemStack displayStack = ReplacementControl.withSkipReplacement(() -> new ItemStack((ItemLike)item2));
                ItemDisplayWidget widget = new ItemDisplayWidget(0, 0, displayStack, button -> this.removeMatchItem(item2), itemId, true);
                this.matchItemWidgets.add(widget);
            }
            for (String tagId : cache.matchTags()) {
                id2 = new ResourceLocation(tagId);
                this.manager.addMatchTag(id2);
                TagDisplayWidget widget = new TagDisplayWidget(0, 0, id2, button -> this.removeMatchTag(id2));
                this.matchTagWidgets.add(widget);
            }
            if (cache.resultItem() != null && (item = (Item)ForgeRegistries.ITEMS.getValue(id = new ResourceLocation(cache.resultItem()))) != null) {
                this.manager.setResultItem(item);
                this.resultItemWidget = new ItemDisplayWidget(0, 0, new ItemStack((ItemLike)item), null);
            }
            if (cache.resultTag() != null) {
                id = new ResourceLocation(cache.resultTag());
                this.manager.setResultTag(id);
                this.resultTagWidget = new TagDisplayWidget(0, 0, id, null);
            }
            if (cache.fileName() != null) {
                this.manager.setCurrentFileName(cache.fileName());
            }
        }
    }

    private void saveToCache() {
        EditorCache.saveCache(this.manager.getMatchItems(), this.manager.getMatchTags(), this.manager.getResultItem(), this.manager.getResultTag(), this.manager.getCurrentFileName());
        this.showMessage((Component)Component.m_237115_((String)"message.oneenoughitem.cache_saved").m_130940_(ChatFormatting.GREEN));
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int topY = 15;
        this.manager.setUiUpdateCallback(this::syncManagerDataToWidgets);
        this.objectDropdownButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.object.select_element"), button -> this.toggleObjectDropdown(), 10, 10, 140, 18);
        this.updateObjectDropdownVisibility();
        int fileY = topY + 25;
        this.datapackNameBox = new EditBox(Minecraft.m_91087_().f_91062_, centerX - 140, fileY, 80, 18, (Component)Component.m_237115_((String)"gui.oneenoughitem.datapack_name"));
        this.datapackNameBox.m_257771_((Component)Component.m_237115_((String)"gui.oneenoughitem.datapack_name.hint"));
        this.m_142416_((GuiEventListener)this.datapackNameBox);
        this.fileNameBox = new EditBox(Minecraft.m_91087_().f_91062_, centerX - 55, fileY, 80, 18, (Component)Component.m_237115_((String)"gui.oneenoughitem.file_name"));
        this.fileNameBox.m_257771_((Component)Component.m_237115_((String)"gui.oneenoughitem.file_name.hint"));
        this.fileNameBox.m_94144_(this.manager.getCurrentFileName());
        this.m_142416_((GuiEventListener)this.fileNameBox);
        this.createFileButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.create_file"), button -> this.createFile(), centerX + 30, fileY, 70, 18);
        this.m_142416_((GuiEventListener)this.createFileButton);
        this.selectFileButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.select_file"), button -> this.selectFile(), centerX + 105, fileY, 70, 18);
        this.m_142416_((GuiEventListener)this.selectFileButton);
        this.reloadButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.reload"), button -> this.reloadDatapacks(), centerX - 140, fileY + 25, 60, 18);
        this.m_142416_((GuiEventListener)this.reloadButton);
        this.clearAllButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.clear_all"), button -> this.clearAll(), centerX - 75, fileY + 25, 60, 18);
        this.m_142416_((GuiEventListener)this.clearAllButton);
        this.saveToJSONButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.save_to_json"), button -> this.saveToJson(), centerX - 10, fileY + 25, 80, 18);
        this.m_142416_((GuiEventListener)this.saveToJSONButton);
        int webBtnX = centerX - 10 + 80 + 8;
        this.openWebEditorButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.web_rules_injector"), button -> this.openWebEditor(), webBtnX, fileY + 25, 90, 18);
        this.m_142416_((GuiEventListener)this.openWebEditorButton);
        int panelY = fileY + 55;
        int leftPanelX = centerX - 220 - 8;
        int rightPanelX = centerX + 8;
        int offsetX = 10;
        this.addMatchItemButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.add_item"), button -> this.openItemSelection(true), leftPanelX + 5 + offsetX, panelY, 70, 18);
        this.m_142416_((GuiEventListener)this.addMatchItemButton);
        this.addMatchTagButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.add_tag"), button -> this.openTagSelection(true), leftPanelX + 70 + 8 + offsetX, panelY, 70, 18);
        this.m_142416_((GuiEventListener)this.addMatchTagButton);
        this.clearMatchButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.clear"), button -> this.clearMatchItems(), leftPanelX + 140 + 11 + offsetX, panelY, 50, 18);
        this.m_142416_((GuiEventListener)this.clearMatchButton);
        int resultButtonSpacing = 10;
        int totalResultButtonWidth = 70 + resultButtonSpacing + 50;
        int resultButtonStartX = rightPanelX + (220 - totalResultButtonWidth) / 2 + offsetX;
        this.selectResultItemButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.select_item"), button -> this.openItemSelection(false), resultButtonStartX, panelY, 70, 18);
        this.m_142416_((GuiEventListener)this.selectResultItemButton);
        this.clearResultButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.clear"), button -> this.clearResultItem(), resultButtonStartX + 70 + resultButtonSpacing, panelY, 50, 18);
        this.m_142416_((GuiEventListener)this.clearResultButton);
        int editorW = Math.round(272.8f);
        int editorH = Math.round(315.7f);
        int editorY = panelY + 0;
        int leftEditorX = leftPanelX + 5;
        int marginX = Math.round(16.12f);
        int headerGap = Math.round(29.315002f);
        int bottomMargin = Math.round(31.570002f);
        this.matchPanel = new ScrollablePanel(leftEditorX + marginX, editorY + headerGap, editorW - marginX * 2, editorH - headerGap - bottomMargin);
        this.m_142416_((GuiEventListener)this.matchPanel);
        this.resultPanel = new ScrollablePanel(rightPanelX + 12, panelY + 32, 210, 110);
        this.m_142416_((GuiEventListener)this.resultPanel);
        this.rebuildPanels();
    }

    private void toggleObjectDropdown() {
        this.showObjectDropdown = !this.showObjectDropdown;
        this.updateObjectDropdown();
    }

    private void syncManagerDataToWidgets() {
        this.matchItemWidgets.clear();
        this.matchTagWidgets.clear();
        this.resultItemWidget = null;
        this.resultTagWidget = null;
        for (Item item : this.manager.getMatchItems()) {
            String originalItemId = Utils.getItemRegistryName(item);
            ItemStack displayStack = ReplacementControl.withSkipReplacement(() -> new ItemStack((ItemLike)item));
            ItemDisplayWidget widget = new ItemDisplayWidget(0, 0, displayStack, button -> this.removeMatchItemById(originalItemId), originalItemId, true);
            this.matchItemWidgets.add(widget);
        }
        for (ResourceLocation tagId : this.manager.getMatchTags()) {
            TagDisplayWidget widget = new TagDisplayWidget(0, 0, tagId, button -> this.removeMatchTag(tagId));
            this.matchTagWidgets.add(widget);
        }
        if (this.manager.getResultItem() != null) {
            this.resultItemWidget = new ItemDisplayWidget(0, 0, new ItemStack((ItemLike)this.manager.getResultItem()), null);
        }
        if (this.manager.getResultTag() != null) {
            this.resultTagWidget = new TagDisplayWidget(0, 0, this.manager.getResultTag(), null);
        }
        this.rebuildPanels();
    }

    private void removeMatchItemById(String itemId) {
        ResourceLocation id;
        Item item;
        if (itemId != null && (item = (Item)ForgeRegistries.ITEMS.getValue(id = new ResourceLocation(itemId))) != null) {
            this.manager.removeMatchItem(item);
            this.matchItemWidgets.removeIf(widget -> itemId.equals(widget.getOriginalItemId()));
            this.rebuildPanels();
        }
    }

    private void updateObjectDropdown() {
        for (Button b : this.objectIndexButtons) {
            this.m_169411_((GuiEventListener)b);
        }
        this.objectIndexButtons.clear();
        this.objectDropdownPanel = ObjectDropdownController.rebuildDropdownPanel(this.objectDropdownButton, this.showObjectDropdown, this.manager, this.objectIndexButtons, this::selectObjectIndex, this::deleteCurrentObjectElement);
        if (this.objectDropdownButton != null) {
            this.objectDropdownButton.m_93666_(ObjectDropdownController.buildDropdownButtonText(this.showObjectDropdown, this.manager));
        }
    }

    private void selectObjectIndex(int index) {
        this.manager.setCurrentObjectIndex(index);
        this.showObjectDropdown = false;
        this.updateObjectDropdown();
    }

    private void deleteCurrentObjectElement() {
        if (this.manager.getCurrentObjectIndex() >= 0) {
            this.manager.deleteObjectElement(this.manager.getCurrentObjectIndex());
            this.showObjectDropdown = false;
            this.updateObjectDropdown();
        }
    }

    private void updateObjectDropdownVisibility() {
        if (this.objectDropdownButton != null) {
            boolean shouldShow;
            this.objectDropdownButton.f_93624_ = shouldShow = this.manager.getCurrentObjectIndex() >= -1 && this.manager.getObjectSize() > 0;
            if (shouldShow) {
                this.m_142416_((GuiEventListener)this.objectDropdownButton);
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 83 && (modifiers & 2) != 0) {
            this.saveToCache();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.f_96543_ / 2;
        int topY = 15;
        int fileY = topY + 25;
        int panelY = fileY + 55;
        int leftPanelX = centerX - 220 - 8;
        int rightPanelX = centerX + 8;
        int editorW = Math.round(272.8f);
        int editorH = Math.round(315.7f);
        int editorY = panelY + 0;
        int leftEditorX = leftPanelX + 5;
        int rightEditorX = rightPanelX + 5;
        GuiUtils.drawEditorPanel(graphics, leftEditorX, editorY, editorW, editorH);
        GuiUtils.drawEditorPanel(graphics, rightEditorX, editorY, editorW, editorH);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, this.f_96539_, centerX, 20, 0xFFFFFF);
        MutableComponent fileName = this.manager.getCurrentFileName().isEmpty() ? Component.m_237115_((String)"gui.oneenoughitem.current_file.none").m_130940_(ChatFormatting.GRAY) : Component.m_237113_((String)this.manager.getCurrentFileName()).m_130940_(ChatFormatting.AQUA);
        MutableComponent fileInfo = Component.m_237110_((String)"gui.oneenoughitem.current_file", (Object[])new Object[]{fileName});
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)fileInfo, centerX, 8, 0xAAAAAA);
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.oneenoughitem.match_items"), leftPanelX + 110, panelY - 12, 0xFFFFFF);
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.oneenoughitem.result_item"), rightPanelX + 110, panelY - 12, 0xFFFFFF);
        String matchCount = Component.m_237110_((String)"gui.oneenoughitem.match_summary", (Object[])new Object[]{this.matchItemWidgets.size(), this.matchTagWidgets.size()}).getString();
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, matchCount, leftPanelX, panelY + 140 + 8, 0xAAAAAA);
        MutableComponent resultText = this.resultItemWidget != null ? Component.m_237115_((String)"gui.oneenoughitem.item_selected") : (this.resultTagWidget != null ? Component.m_237115_((String)"gui.oneenoughitem.tag_selected") : Component.m_237115_((String)"gui.oneenoughitem.no_result"));
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)resultText, rightPanelX, panelY + 140 + 8, 0xAAAAAA);
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.oneenoughitem.save_to_cache"), centerX, panelY + 140 + 25, 0xFFFF00);
        if (this.showObjectDropdown && this.objectDropdownPanel != null) {
            this.objectDropdownPanel.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
    }

    private void createFile() {
        String datapackName = this.datapackNameBox.m_94155_().trim();
        String fileName = this.fileNameBox.m_94155_().trim();
        if (fileName.isEmpty()) {
            this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.file_name_empty").m_130940_(ChatFormatting.RED));
            return;
        }
        String newName = this.fileActions.createFile(datapackName, fileName);
        this.fileNameBox.m_94144_(newName);
    }

    private void saveToJson() {
        this.fileActions.saveToJson();
    }

    private void openWebEditor() {
        String message = WebEditorServer.openInBrowser();
        if (message != null) {
            this.showMessage((Component)Component.m_237113_((String)message).m_130940_(ChatFormatting.YELLOW));
        }
    }

    private void selectFile() {
        this.fileActions.selectFile(this.f_96541_, this);
    }

    public void onFileSelected(Path filePath, int mode) {
        switch (mode) {
            case 0: {
                this.manager.selectJsonFile(filePath, 0);
                this.syncManagerDataToWidgets();
                break;
            }
            case 1: {
                this.manager.selectJsonFile(filePath, 1);
                this.syncManagerDataToWidgets();
                break;
            }
            case 2: {
                this.manager.deleteFile(filePath);
            }
        }
    }

    private void removeMatchItem(Item item) {
        boolean removed = this.itemsController.removeMatchItem(item);
        if (removed) {
            this.syncManagerDataToWidgets();
        }
    }

    private void reloadDatapacks() {
        this.manager.reloadDatapacks();
    }

    private void clearAll() {
        this.manager.clearAll();
        this.matchItemWidgets.clear();
        this.matchTagWidgets.clear();
        this.resultItemWidget = null;
        this.resultTagWidget = null;
        this.fileNameBox.m_94144_("");
        this.rebuildPanels();
        this.updateObjectDropdownVisibility();
        this.updateObjectDropdown();
        EditorCache.clearCache();
    }

    private void openItemSelection(boolean isForMatch) {
        this.f_96541_.m_91152_((Screen)new ItemSelectionScreen(this, isForMatch));
    }

    private void openTagSelection(boolean isForMatch) {
        if (isForMatch) {
            this.f_96541_.m_91152_((Screen)new TagSelectionScreen(this, true));
        }
    }

    private void clearMatchItems() {
        this.matchItemWidgets.clear();
        this.matchTagWidgets.clear();
        this.itemsController.clearMatchItems();
        this.rebuildPanels();
    }

    private void clearResultItem() {
        this.resultItemWidget = null;
        this.resultTagWidget = null;
        this.itemsController.clearResultItem();
        this.rebuildPanels();
    }

    public void addMatchItem(Item item) {
        String itemId = Utils.getItemRegistryName(item);
        if (itemId != null) {
            String runtimeReplacement = ReplacementCache.matchItem(itemId);
            String globalReplacement = GlobalReplacementCache.getItemReplacement(itemId);
            if (runtimeReplacement != null || globalReplacement != null) {
                this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.item_already_replaced").m_130940_(ChatFormatting.RED));
                return;
            }
            if (GlobalReplacementCache.isItemUsedAsResult(itemId)) {
                this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.item_used_as_result").m_130940_(ChatFormatting.RED));
                return;
            }
        }
        this.itemsController.addMatchItem(item);
        this.syncManagerDataToWidgets();
    }

    public void addMatchTag(ResourceLocation tagId) {
        if (this.manager.getMatchTags().contains(tagId)) {
            this.showWarn((Component)Component.m_237115_((String)"warning.oneenoughitem.tag_exists").m_130940_(ChatFormatting.YELLOW));
            return;
        }
        ReplacementUtils.ReplacementInfo replacementInfo = ReplacementUtils.getTagReplacementInfo(tagId);
        if (replacementInfo.isReplaced()) {
            this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.tag_already_replaced").m_130940_(ChatFormatting.RED));
            return;
        }
        this.itemsController.addMatchTag(tagId);
        this.syncManagerDataToWidgets();
    }

    public void setResultItem(Item item) {
        String itemId = Utils.getItemRegistryName(item);
        if (itemId != null) {
            String runtimeReplacement = ReplacementCache.matchItem(itemId);
            String globalReplacement = GlobalReplacementCache.getItemReplacement(itemId);
            if (runtimeReplacement != null || globalReplacement != null) {
                this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.result_item_already_replaced").m_130940_(ChatFormatting.RED));
                return;
            }
            if (GlobalReplacementCache.isItemReplaced(itemId)) {
                this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.result_item_used_as_match").m_130940_(ChatFormatting.RED));
                return;
            }
        }
        this.itemsController.setResultItem(item);
        this.syncManagerDataToWidgets();
    }

    public void setResultTag(ResourceLocation tagId) {
        this.itemsController.setResultTag(tagId);
        this.resultTagWidget = new TagDisplayWidget(0, 0, tagId, null);
        this.resultItemWidget = null;
        this.rebuildPanels();
    }

    private void removeMatchTag(ResourceLocation tagId) {
        this.itemsController.removeMatchTag(tagId);
        this.matchTagWidgets.removeIf(widget -> widget.getTagId().equals((Object)tagId));
        this.rebuildPanels();
    }

    protected void rebuildPanels() {
        this.panelsHelper.rebuildPanels(this.matchPanel, this.resultPanel, this.matchItemWidgets, this.matchTagWidgets, this.resultItemWidget, this.resultTagWidget);
    }

    private void showError(Component message) {
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5661_(message, false);
        }
    }

    private void showWarn(Component message) {
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5661_(message, false);
        }
    }

    private void showMessage(Component message) {
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5661_(message, false);
        }
    }

    public List<Path> scanReplacementFiles() {
        return this.fileActions.scanReplacementFiles();
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.showObjectDropdown && this.objectDropdownPanel != null && this.objectDropdownPanel.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.showObjectDropdown && this.objectDropdownPanel != null && this.objectDropdownPanel.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.showObjectDropdown && this.objectDropdownPanel != null && this.objectDropdownPanel.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.showObjectDropdown && this.objectDropdownPanel != null && this.objectDropdownPanel.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }
}

