/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui;

import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.cache.GlobalReplacementCache;
import com.mafuyu404.oneenoughitem.client.gui.components.ItemGridWidget;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.init.ReplacementCache;
import com.mafuyu404.oneenoughitem.init.ReplacementControl;
import com.mafuyu404.oneenoughitem.init.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemSelectionScreen
extends Screen {
    private static final int ITEMS_PER_PAGE = 45;
    private static final int GRID_WIDTH = 9;
    private static final int GRID_HEIGHT = 5;
    private final ReplacementEditorScreen parent;
    private final boolean isForMatch;
    private EditBox searchBox;
    private Button sortButton;
    private Button prevPageButton;
    private Button nextPageButton;
    private Button backButton;
    private ItemGridWidget itemGrid;
    private List<Item> allItems;
    private List<Item> filteredItems;
    private int currentPage = 0;
    private SortMode sortMode = SortMode.NAME;
    private final Set<String> selectedItemIds = new HashSet<String>();
    private Button confirmSelectionButton;
    private Button clearSelectionButton;
    private int lastSearchLength = 0;

    public ItemSelectionScreen(ReplacementEditorScreen parent, boolean isForMatch) {
        super((Component)Component.m_237115_((String)"gui.oneenoughitem.item_selection.title"));
        this.parent = parent;
        this.isForMatch = isForMatch;
        this.initializeItems();
    }

    private void initializeItems() {
        this.allItems = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item != Items.f_41852_).collect(Collectors.toList());
        this.filteredItems = new ArrayList<Item>(this.allItems);
        this.sortItems();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        this.searchBox = new EditBox(this.f_96547_, centerX - 80, 15, 160, 18, (Component)Component.m_237115_((String)"gui.oneenoughitem.search"));
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"gui.oneenoughitem.search.hint"));
        this.m_142416_((GuiEventListener)this.searchBox);
        this.sortButton = GuiUtils.createButton((Component)Component.m_237115_((String)("gui.oneenoughitem.sort." + this.sortMode.name().toLowerCase())), btn -> this.cycleSortMode(), centerX + 90, 15, 70, 18);
        this.m_142416_((GuiEventListener)this.sortButton);
        int gridStartX = centerX - 81;
        int gridStartY = 45;
        this.itemGrid = new ItemGridWidget(gridStartX, gridStartY, 9, 5, this::selectItem);
        this.itemGrid.setSelectedItemIds(this.selectedItemIds);
        this.m_142416_((GuiEventListener)this.itemGrid);
        int buttonY = gridStartY + 90 + 10;
        this.prevPageButton = GuiUtils.createButton((Component)Component.m_237113_((String)"<"), btn -> this.previousPage(), centerX - 80, buttonY, 25, 18);
        this.m_142416_((GuiEventListener)this.prevPageButton);
        this.nextPageButton = GuiUtils.createButton((Component)Component.m_237113_((String)">"), btn -> this.nextPage(), centerX + 55, buttonY, 25, 18);
        this.m_142416_((GuiEventListener)this.nextPageButton);
        this.backButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.back"), btn -> this.m_7379_(), centerX - 40, buttonY, 80, 18);
        this.m_142416_((GuiEventListener)this.backButton);
        if (this.isForMatch) {
            this.confirmSelectionButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.add_selected"), btn -> this.confirmSelectedItems(), centerX - 120, buttonY + 25, 100, 18);
            this.m_142416_((GuiEventListener)this.confirmSelectionButton);
            this.clearSelectionButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.clear_selected"), btn -> {
                this.selectedItemIds.clear();
                this.updateGrid();
                this.updateConfirmButtonsVisibility();
            }, centerX + 20, buttonY + 25, 100, 18);
            this.m_142416_((GuiEventListener)this.clearSelectionButton);
            this.updateConfirmButtonsVisibility();
        }
        this.updateGrid();
        this.updateNavigationButtons();
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.searchBox.m_94155_().length() != this.getLastSearchLength()) {
            this.filterItems();
            this.currentPage = 0;
            this.updateGrid();
            this.updateNavigationButtons();
        }
    }

    private int getLastSearchLength() {
        int current = this.lastSearchLength;
        this.lastSearchLength = this.searchBox.m_94155_().length();
        return current;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        int totalPages = (this.filteredItems.size() + 45 - 1) / 45;
        String pageInfo = this.currentPage + 1 + " / " + Math.max(1, totalPages);
        int buttonY = 145;
        graphics.m_280137_(this.f_96547_, pageInfo, this.f_96543_ / 2, buttonY + 25, 0xFFFFFF);
        String itemCount = this.filteredItems.size() + " items";
        graphics.m_280488_(this.f_96547_, itemCount, 10, buttonY + 35, 0xFFFFFF);
    }

    private void cycleSortMode() {
        this.sortMode = SortMode.values()[(this.sortMode.ordinal() + 1) % SortMode.values().length];
        this.sortButton.m_93666_((Component)Component.m_237115_((String)("gui.oneenoughitem.sort." + this.sortMode.name().toLowerCase())));
        this.sortItems();
        this.currentPage = 0;
        this.updateGrid();
        this.updateNavigationButtons();
    }

    private void sortItems() {
        switch (this.sortMode) {
            case NAME: {
                this.filteredItems.sort(Comparator.comparing(item -> item.m_41466_().getString()));
                break;
            }
            case MOD: {
                this.filteredItems.sort(Comparator.comparing(item -> ForgeRegistries.ITEMS.getKey(item).m_135827_()));
                break;
            }
            case ID: {
                this.filteredItems.sort(Comparator.comparing(item -> ForgeRegistries.ITEMS.getKey(item).toString()));
            }
        }
    }

    private void filterItems() {
        String search = this.searchBox.m_94155_().toLowerCase();
        this.filteredItems = search.isEmpty() ? new ArrayList<Item>(this.allItems) : this.allItems.stream().filter(item -> {
            String itemName = item.m_41466_().getString().toLowerCase();
            String itemId = ForgeRegistries.ITEMS.getKey(item).toString().toLowerCase();
            return itemName.contains(search) || itemId.contains(search);
        }).collect(Collectors.toList());
        this.sortItems();
    }

    private void updateGrid() {
        ArrayList<ItemStack> pageItems = new ArrayList<ItemStack>();
        int startIndex = this.currentPage * 45;
        int endIndex = Math.min(startIndex + 45, this.filteredItems.size());
        int i = startIndex;
        while (i < endIndex) {
            int finalI = i++;
            ItemStack itemStack = ReplacementControl.withSkipReplacement(() -> new ItemStack((ItemLike)this.filteredItems.get(finalI)));
            pageItems.add(itemStack);
        }
        this.itemGrid.setItems(pageItems);
    }

    private void updateNavigationButtons() {
        int totalPages = (this.filteredItems.size() + 45 - 1) / 45;
        this.prevPageButton.f_93623_ = this.currentPage > 0;
        this.nextPageButton.f_93623_ = this.currentPage < totalPages - 1;
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.updateGrid();
            this.updateNavigationButtons();
        }
    }

    private void nextPage() {
        int totalPages = (this.filteredItems.size() + 45 - 1) / 45;
        if (this.currentPage < totalPages - 1) {
            ++this.currentPage;
            this.updateGrid();
            this.updateNavigationButtons();
        }
    }

    private void selectItem(ItemStack itemStack) {
        String itemId = Utils.getItemRegistryName(itemStack.m_41720_());
        if (itemId == null) {
            return;
        }
        if (this.isForMatch && ItemSelectionScreen.m_96637_()) {
            if (this.selectedItemIds.contains(itemId)) {
                this.selectedItemIds.remove(itemId);
            } else if (this.checkItemSelectable(itemId, true)) {
                this.selectedItemIds.add(itemId);
            }
            this.updateGrid();
            this.updateConfirmButtonsVisibility();
            return;
        }
        if (!this.checkItemSelectable(itemId, this.isForMatch)) {
            return;
        }
        if (this.isForMatch) {
            this.parent.addMatchItem(itemStack.m_41720_());
        } else {
            this.parent.setResultItem(itemStack.m_41720_());
        }
        this.m_7379_();
    }

    private boolean checkItemSelectable(String itemId, boolean isForMatch) {
        String runtimeReplacement = ReplacementCache.matchItem(itemId);
        String globalReplacement = GlobalReplacementCache.getItemReplacement(itemId);
        if (runtimeReplacement != null || globalReplacement != null) {
            this.showError("error.oneenoughitem.item_already_replaced");
            return false;
        }
        if (isForMatch) {
            if (GlobalReplacementCache.isItemUsedAsResult(itemId)) {
                this.showError("error.oneenoughitem.item_used_as_result");
                return false;
            }
        } else if (GlobalReplacementCache.isItemReplaced(itemId)) {
            this.showError("error.oneenoughitem.result_item_used_as_match");
            return false;
        }
        return true;
    }

    private void showError(String translationKey) {
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)translationKey).m_130940_(ChatFormatting.RED), false);
        }
    }

    private void confirmSelectedItems() {
        if (!this.isForMatch || this.selectedItemIds.isEmpty()) {
            return;
        }
        int added = 0;
        for (String id : new ArrayList<String>(this.selectedItemIds)) {
            Item item;
            ResourceLocation rl = ResourceLocation.m_135820_((String)id);
            if (rl == null || (item = (Item)ForgeRegistries.ITEMS.getValue(rl)) == null || item == Items.f_41852_) continue;
            String runtimeReplacement = ReplacementCache.matchItem(id);
            String globalReplacement = GlobalReplacementCache.getItemReplacement(id);
            if (runtimeReplacement != null || globalReplacement != null || GlobalReplacementCache.isItemUsedAsResult(id)) continue;
            this.parent.addMatchItem(item);
            ++added;
        }
        this.selectedItemIds.clear();
        this.updateGrid();
        this.updateConfirmButtonsVisibility();
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237110_((String)"message.oneenoughitem.multi_add_result", (Object[])new Object[]{added}).m_130940_(ChatFormatting.GREEN), false);
        }
        this.m_7379_();
    }

    private void updateConfirmButtonsVisibility() {
        boolean hasSelection;
        if (!this.isForMatch) {
            return;
        }
        boolean bl = hasSelection = !this.selectedItemIds.isEmpty();
        if (this.confirmSelectionButton != null) {
            this.confirmSelectionButton.f_93623_ = hasSelection;
        }
        if (this.clearSelectionButton != null) {
            this.clearSelectionButton.f_93623_ = hasSelection;
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    private static enum SortMode {
        NAME,
        MOD,
        ID;

    }
}

