/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.net;

import dev.shadowsoffire.gateways.client.ParticleHandler;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.placebo.network.MessageHelper;
import dev.shadowsoffire.placebo.network.MessageProvider;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ParticleMessage {
    public int gateId;
    public double x;
    public double y;
    public double z;
    public Type type;
    public int color;

    public ParticleMessage(GatewayEntity source, double x, double y, double z, TextColor color, Type type) {
        this(source.m_19879_(), x, y, z, color.m_131265_(), type);
    }

    public ParticleMessage(int id, double x, double y, double z, int color, Type type) {
        this.gateId = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.color = color;
        this.type = type;
    }

    public static enum Type {
        IDLE,
        SPAWNED;

    }

    public static class Provider
    implements MessageProvider<ParticleMessage> {
        public Class<ParticleMessage> getMsgClass() {
            return ParticleMessage.class;
        }

        public ParticleMessage read(FriendlyByteBuf buf) {
            int id = buf.readInt();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            int color = buf.readInt();
            Type type = Type.values()[buf.readByte()];
            return new ParticleMessage(id, x, y, z, color, type);
        }

        public void write(ParticleMessage msg, FriendlyByteBuf buf) {
            buf.writeInt(msg.gateId);
            buf.writeDouble(msg.x);
            buf.writeDouble(msg.y);
            buf.writeDouble(msg.z);
            buf.writeInt(msg.color);
            buf.writeByte(msg.type.ordinal());
        }

        public void handle(ParticleMessage msg, Supplier<NetworkEvent.Context> ctx) {
            MessageHelper.handlePacket(() -> ParticleHandler.handle(msg), ctx);
        }

        public Optional<NetworkDirection> getNetworkDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

