/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class GatewayRenderer
extends EntityRenderer<GatewayEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("gateways", "textures/entity/gateway.png");

    public GatewayRenderer(EntityRendererProvider.Context mgr) {
        super(mgr);
    }

    public ResourceLocation getTextureLocation(GatewayEntity entity) {
        return TEXTURE;
    }

    public void render(GatewayEntity gate, float yaw, float partialTicks, PoseStack matrix, MultiBufferSource buf, int packedLight) {
        float baseScale;
        if (!gate.isValid()) {
            return;
        }
        matrix.m_85836_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 playerV = player.m_20299_(partialTicks);
        Vec3 portal = gate.m_20182_();
        float scale = baseScale = gate.getGateway().size().getScale();
        double yOffset = gate.m_20206_() / 2.0f;
        matrix.m_85837_(0.0, yOffset, 0.0);
        matrix.m_252781_(new Quaternionf().rotationAxis(1.5707964f, 0.0f, 1.0f, 0.0f));
        matrix.m_252781_(new Quaternionf().rotationAxis((float)Math.PI / 180 * (180.0f - (float)GatewayRenderer.angleOf(portal, playerV)), 0.0f, 1.0f, 0.0f));
        matrix.m_85841_(2.0f, 1.0f, 1.0f);
        if (!gate.isWaveActive() && gate.isCompleted()) {
            float maxTime;
            time = (float)gate.getTicksActive() + partialTicks;
            if (time <= (maxTime = (float)gate.getSetupTime())) {
                scale = Mth.m_14179_((float)(time / maxTime), (float)gate.getClientScale(), (float)baseScale);
            }
        } else {
            int magic;
            time = (float)gate.getTicksActive() + partialTicks;
            if (time < (float)(magic = 10)) {
                matrix.m_85841_(Mth.m_14179_((float)(time / (float)magic), (float)1.0f, (float)1.33f), 1.0f, 1.0f);
                matrix.m_85841_(1.0f, Mth.m_14179_((float)(time / (float)magic), (float)1.0f, (float)1.33f), 1.0f);
            } else if (time < (float)(2 * magic)) {
                matrix.m_85841_(Mth.m_14179_((float)((time -= (float)magic) / (float)magic), (float)1.33f, (float)1.0f), 1.0f, 1.0f);
                matrix.m_85841_(1.0f, Mth.m_14179_((float)(time / (float)magic), (float)1.33f, (float)1.0f), 1.0f);
            } else {
                float progress = ((float)gate.getTicksActive() + partialTicks - 20.0f) % 80.0f / 80.0f;
                gate.setClientScale(scale += (float)Math.sin(Math.PI * 2 * (double)progress) * baseScale / 6.0f);
            }
        }
        matrix.m_85841_(scale, scale, 1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation(gate));
        VertexConsumer builder = buf.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(gate)));
        int color = gate.getGateway().color().m_131265_();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float frameHeight = 0.11111111f;
        int frame = gate.f_19797_ % 9;
        builder.m_252986_(matrix.m_85850_().m_252922_(), -1.0f, -1.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(1.0f, 1.0f - (float)frame * frameHeight).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix.m_85850_().m_252922_(), -1.0f, 1.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(1.0f, 0.8888889f - (float)frame * frameHeight).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix.m_85850_().m_252922_(), 1.0f, 1.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 0.8888889f - (float)frame * frameHeight).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix.m_85850_().m_252922_(), 1.0f, -1.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 1.0f - (float)frame * frameHeight).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        matrix.m_85849_();
        if (gate.getGateway().bossSettings().drawAsName()) {
            matrix.m_85836_();
            matrix.m_252880_(0.0f, gate.m_20206_() + 1.0f, 0.0f);
            matrix.m_252781_(this.f_114476_.m_253208_());
            matrix.m_85841_(-0.02f, -0.02f, 0.02f);
            GuiGraphics gfx = new GuiGraphics(Minecraft.m_91087_(), matrix, Minecraft.m_91087_().m_91269_().m_110104_());
            RenderSystem.enableDepthTest();
            gate.getGateway().renderBossBar(gate, gfx, -100, 0, true);
            gfx.m_280262_();
            matrix.m_85849_();
        }
    }

    public static double angleOf(Vec3 p1, Vec3 p2) {
        double deltaY = p2.f_82481_ - p1.f_82481_;
        double deltaX = p2.f_82479_ - p1.f_82479_;
        double result = Math.toDegrees(Math.atan2(deltaY, deltaX));
        return result < 0.0 ? 360.0 + result : result;
    }
}

