/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.belt_grinder;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.lucreeper74.createmetallurgy.content.blocks.belt_grinder.BeltGrinderBlock;
import fr.lucreeper74.createmetallurgy.content.blocks.belt_grinder.BeltGrinderBlockEntity;
import fr.lucreeper74.createmetallurgy.registries.CMPartialModels;
import fr.lucreeper74.createmetallurgy.registries.CMSpriteShifts;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BeltGrinderRenderer
extends SafeBlockEntityRenderer<BeltGrinderBlockEntity> {
    public BeltGrinderRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(BeltGrinderBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderShaft(be, ms, buffer, light, overlay);
        this.renderBelt(be, ms, buffer, light);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)be, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
    }

    protected void renderBelt(BeltGrinderBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light) {
        BlockState blockState = be.m_58900_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        SpriteShiftEntry beltShift = CMSpriteShifts.SAND_PAPER_BELT;
        float speed = be.getSpeed() * 2.0f;
        float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float time = renderTick * (float)Direction.AxisDirection.POSITIVE.m_122540_();
        float spriteSize = beltShift.getTarget().m_118412_() - beltShift.getTarget().m_118411_();
        double scroll = (double)(speed * time) / 504.0;
        scroll -= Math.floor(scroll);
        scroll = scroll * (double)spriteSize * 0.5;
        SuperByteBuffer rotatedCoil = CachedBuffers.partialFacing((PartialModel)CMPartialModels.GRINDER_BELT, (BlockState)blockState, (Direction)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)));
        rotatedCoil.light(light).renderInto(ms, vb);
        rotatedCoil.shiftUVScrolling(beltShift, (float)scroll).light(light).renderInto(ms, vb);
    }

    protected void renderItems(BeltGrinderBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.inv.isEmpty()) {
            boolean alongZ = ((Direction)be.m_58900_().m_61143_(BeltGrinderBlock.HORIZONTAL_FACING)).m_122434_() == Direction.Axis.Z;
            ms.m_85836_();
            float offset = BeltGrinderRenderer.getOffset(be, partialTicks, alongZ);
            for (int i = 0; i < be.inv.getSlots(); ++i) {
                ItemStack stack = be.inv.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Minecraft mc = Minecraft.m_91087_();
                ItemRenderer itemRenderer = mc.m_91291_();
                BakedModel modelWithOverrides = itemRenderer.m_174264_(stack, be.m_58904_(), null, 0);
                boolean blockItem = modelWithOverrides.m_7539_();
                ms.m_85837_(alongZ ? (double)offset : 0.5, blockItem ? (double)0.925f : 0.8125, alongZ ? 0.5 : (double)offset);
                ms.m_85841_(0.5f, 0.5f, 0.5f);
                if (alongZ) {
                    ms.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                }
                ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, (Level)mc.f_91073_, 0);
                break;
            }
            ms.m_85849_();
        }
    }

    private void renderShaft(BeltGrinderBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel(be), (PoseStack)ms, (VertexConsumer)buffer.m_6299_(RenderType.m_110451_()), (int)light);
    }

    private SuperByteBuffer getRotatedModel(BeltGrinderBlockEntity be) {
        return CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)this.getRenderedBlockState(be));
    }

    protected BlockState getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }

    private static float getOffset(BeltGrinderBlockEntity be, float partialTicks, boolean alongZ) {
        boolean moving = be.inv.recipeDuration != 0.0f;
        float offset = moving ? be.inv.remainingTime / be.inv.recipeDuration : 0.0f;
        float processingSpeed = Mth.m_14036_((float)(Math.abs(be.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
        if (moving) {
            offset = Mth.m_14036_((float)(offset + (-partialTicks + 0.5f) * processingSpeed / be.inv.recipeDuration), (float)0.125f, (float)1.0f);
            if (!be.inv.appliedRecipe) {
                offset += 1.0f;
            }
            offset /= 2.0f;
        }
        if (be.getSpeed() == 0.0f) {
            offset = 0.5f;
        }
        if (be.getSpeed() < 0.0f ^ alongZ) {
            offset = 1.0f - offset;
        }
        return offset;
    }
}

