/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.smsn.compat;

import dev.aika.smsn.SMSN;
import dev.aika.smsn.annotation.Category;
import dev.aika.smsn.annotation.Ignored;
import dev.aika.smsn.annotation.LoaderSpecific;
import dev.aika.smsn.api.LoaderType;
import dev.aika.smsn.client.gui.ComponentBuilder;
import dev.aika.smsn.config.ModConfig;
import dev.aika.smsn.config.SMSNConfigDefault;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.clothconfig2.impl.ConfigCategoryImpl;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ClothConfigCompat {
    private static final Logger log = SMSN.LOGGER;
    private static final Marker marker = MarkerFactory.getMarker((String)"ClothConfigCompat");
    private static final String modid = "smsn";
    private static final String sponsorUrl = "https://afdian.com/a/gizmo";
    private static final Class<?> configDefault = SMSNConfigDefault.class;

    public static Screen ConfigScreen(ModConfig config, Screen parent) {
        Field[] fields;
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setSavingRunnable(config::save).setTitle((Component)Component.m_237115_((String)String.format("config.%s.title", modid)));
        ComponentBuilder componentBuilder = new ComponentBuilder(builder.entryBuilder(), config).setModId(modid).setDefaultObject(configDefault);
        for (Field field : fields = config.getClass().getDeclaredFields()) {
            ClothConfigCompat.addEntry(builder, componentBuilder, field);
        }
        builder.transparentBackground();
        return builder.build();
    }

    private static ConfigCategory getCategory(ConfigBuilder builder, ComponentBuilder componentBuilder, String categoryKey) {
        ConfigCategory category = builder.getOrCreateCategory((Component)Component.m_237115_((String)String.format("config.%s.%s", modid, categoryKey)));
        if (((ConfigCategoryImpl)category).getEntries().isEmpty()) {
            category.addEntry((AbstractConfigListEntry)ClothConfigCompat.sponsorDescription(componentBuilder.getEntryBuilder()));
        }
        return category;
    }

    private static boolean isIgnored(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            return true;
        }
        if (field.getAnnotation(Ignored.class) != null) {
            return true;
        }
        LoaderSpecific loaderAnnotation = field.getAnnotation(LoaderSpecific.class);
        if (loaderAnnotation != null) {
            return !List.of(loaderAnnotation.value()).contains((Object)LoaderType.getCurrentLoader());
        }
        return false;
    }

    private static void addEntry(ConfigBuilder builder, ComponentBuilder componentBuilder, Field field) {
        if (ClothConfigCompat.isIgnored(field)) {
            return;
        }
        Category categoryAnnotation = field.getAnnotation(Category.class);
        String category = categoryAnnotation != null ? categoryAnnotation.value() : "general";
        ConfigCategory configCategory = ClothConfigCompat.getCategory(builder, componentBuilder, category);
        Class<?> fieldType = field.getType();
        if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
            configCategory.addEntry(componentBuilder.switchBuilder(field, category).build());
        } else if (fieldType.equals(String.class)) {
            configCategory.addEntry(componentBuilder.stringInputBuilder(field, category).build());
        } else if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
            configCategory.addEntry(componentBuilder.intInputBuilder(field, category).build());
        } else if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
            configCategory.addEntry(componentBuilder.floatInputBuilder(field, category).build());
        } else if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
            configCategory.addEntry(componentBuilder.doubleInputBuilder(field, category).build());
        } else if (fieldType.isEnum()) {
            configCategory.addEntry(componentBuilder.enumSelectorBuilder(field, category, fieldType).build());
        } else {
            log.warn(marker, "Unsupported field type: {}", fieldType);
        }
    }

    public static TextListEntry sponsorDescription(ConfigEntryBuilder entryBuilder) {
        return entryBuilder.startTextDescription((Component)Component.m_237110_((String)String.format("config.%s.sponsor.description", modid), (Object[])new Object[]{Component.m_237115_((String)"modmenu.nameTranslation.smsn").m_130938_(s -> s.m_131140_(ChatFormatting.AQUA).m_131136_(Boolean.valueOf(true))), Component.m_237115_((String)String.format("config.%s.sponsor.description.afdian", modid)).m_130938_(s -> s.m_131140_(ChatFormatting.DARK_PURPLE).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)sponsorUrl))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, sponsorUrl)))})).build();
    }
}

