/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.smsn.client.gui.components;

import java.lang.reflect.Field;
import lombok.Generated;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractComponentBuilder<T> {
    protected final ConfigEntryBuilder entryBuilder;
    protected final Object configObject;
    protected Class<?> defaultObject;
    protected Field field;
    protected String category;
    protected String modId;

    public AbstractComponentBuilder(ConfigEntryBuilder entryBuilder, Object configObject, Field field) {
        this.entryBuilder = entryBuilder;
        this.configObject = configObject;
        this.field = field;
    }

    protected T getValue() {
        this.field.setAccessible(true);
        return (T)this.field.get(this.configObject);
    }

    protected void setValue(T value) {
        this.field.setAccessible(true);
        this.field.set(this.configObject, value);
    }

    protected T getDefaultValue() {
        Field _field;
        try {
            _field = this.defaultObject.getDeclaredField(this.field.getName());
        }
        catch (NoSuchFieldException e) {
            return this.getValue();
        }
        _field.setAccessible(true);
        return (T)_field.get(null);
    }

    protected String translatableKeyPrefix() {
        return String.format("config.%s.%s", this.modId, this.category);
    }

    protected Component fieldNameKey() {
        return Component.m_237115_((String)String.format("%s.%s", this.translatableKeyPrefix(), this.field.getName()));
    }

    public abstract AbstractConfigListEntry<T> build();

    @Generated
    public AbstractComponentBuilder<T> setDefaultObject(Class<?> defaultObject) {
        this.defaultObject = defaultObject;
        return this;
    }

    @Generated
    public AbstractComponentBuilder<T> setCategory(String category) {
        this.category = category;
        return this;
    }

    @Generated
    public AbstractComponentBuilder<T> setModId(String modId) {
        this.modId = modId;
        return this;
    }
}

