/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.init.data;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class CDConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.DoubleValue uiScale;
        public final ForgeConfigSpec.IntValue uiXAnchor;
        public final ForgeConfigSpec.IntValue uiXOffset;
        public final ForgeConfigSpec.IntValue uiYAnchor;
        public final ForgeConfigSpec.IntValue uiYOffset;

        Client(ForgeConfigSpec.Builder builder) {
            this.uiScale = builder.comment("Cooking UI Scale").defineInRange("uiScale", 1.0, 0.0, 16.0);
            this.uiXAnchor = builder.defineInRange("uiXAnchor", -1, -1, 1);
            this.uiXOffset = builder.defineInRange("uiXOffset", 8, -1000, 1000);
            this.uiYAnchor = builder.defineInRange("uiYAnchor", 0, -1, 1);
            this.uiYOffset = builder.defineInRange("uiYOffset", 0, -1000, 1000);
        }
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue baseServe;
        public final ForgeConfigSpec.DoubleValue baseNutrition;
        public final ForgeConfigSpec.DoubleValue varietyBonus;
        public final ForgeConfigSpec.DoubleValue perfectionBonus;
        public final ForgeConfigSpec.IntValue nourishmentDuration;
        public final ForgeConfigSpec.IntValue maxIngredient;
        public final ForgeConfigSpec.BooleanValue enableSoLCompat;
        public final ForgeConfigSpec.BooleanValue enableDietCompat;

        Common(ForgeConfigSpec.Builder builder) {
            this.baseServe = builder.comment("base size per serve").defineInRange("baseServe", 4, 1, 100);
            this.baseNutrition = builder.comment("base nutrition factor").defineInRange("baseNutrition", 0.1, 0.0, 100.0);
            this.varietyBonus = builder.comment("bonus for every extra food type").defineInRange("varietyBonus", 0.2, 0.0, 100.0);
            this.perfectionBonus = builder.comment("bonus for perfect food").defineInRange("perfectionBonus", 0.5, 0.0, 100.0);
            this.maxIngredient = builder.comment("max number of ingredient entries").defineInRange("maxIngredient", 9, 1, 20);
            this.nourishmentDuration = builder.comment("nourishment duration per food type").defineInRange("nourishmentDuration", 100, 1, 10000);
            this.enableSoLCompat = builder.comment("Enable SoL compat so that eating a dish is equivalent to eating all components").define("enableSoLCompat", true);
            this.enableDietCompat = builder.comment("Enable Diet compat so that eating a dish is equivalent to eating all components").define("enableDietCompat", true);
        }
    }
}

