/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.item;

import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.item.CuisineSkilletItem;
import dev.xkmc.cuisinedelight.content.logic.CookedFoodData;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.content.recipe.BaseCuisineRecipe;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class PlateItem
extends Item {
    public PlateItem(Item.Properties pProperties) {
        super(pProperties);
    }

    private void giveBack(ItemStack foodStack, CookedFoodData food, ReturnTarget target) {
        target.addItem(foodStack);
        target.addExp(food.score * food.size / 100);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack plateStack = player.m_21120_(hand);
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack skilletStack = player.m_21120_(otherHand);
        if (!skilletStack.m_150930_((Item)CDItems.SKILLET.get())) {
            return InteractionResultHolder.m_19098_((Object)plateStack);
        }
        CookingData data = CuisineSkilletItem.getData(skilletStack);
        if (data == null) {
            return InteractionResultHolder.m_19098_((Object)plateStack);
        }
        if (!level.m_5776_()) {
            CuisineSkilletItem.setData(skilletStack, null);
            data.stir(level.m_46467_(), 0);
            CookedFoodData food = new CookedFoodData(data);
            ItemStack foodStack = BaseCuisineRecipe.findBestMatch(level, food);
            plateStack.m_41774_(1);
            this.giveBack(foodStack, food, new PlayerTarget(player));
        }
        return InteractionResultHolder.m_19090_((Object)plateStack);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        BlockEntity blockEntity = level.m_7702_(ctx.m_8083_());
        if (blockEntity instanceof CuisineSkilletBlockEntity) {
            CuisineSkilletBlockEntity be = (CuisineSkilletBlockEntity)blockEntity;
            if (be.cookingData.contents.isEmpty()) {
                return InteractionResult.PASS;
            }
            if (!level.m_5776_()) {
                CookingData data = be.cookingData;
                data.stir(level.m_46467_(), 0);
                CookedFoodData food = new CookedFoodData(data);
                ItemStack foodStack = BaseCuisineRecipe.findBestMatch(level, food);
                ctx.m_43722_().m_41774_(1);
                if (player != null) {
                    this.giveBack(foodStack, food, new PlayerTarget(player));
                } else {
                    this.giveBack(foodStack, food, new BlockTarget(ctx));
                }
                be.cookingData = new CookingData();
                be.sync();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static interface ReturnTarget {
        public void addItem(ItemStack var1);

        public void addExp(int var1);
    }

    public record PlayerTarget(Player player) implements ReturnTarget
    {
        @Override
        public void addItem(ItemStack foodStack) {
            this.player.m_150109_().m_150079_(foodStack);
        }

        @Override
        public void addExp(int i) {
            ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.player.m_9236_()), (Vec3)this.player.m_20182_(), (int)i);
        }
    }

    public record BlockTarget(UseOnContext ctx) implements ReturnTarget
    {
        @Override
        public void addItem(ItemStack foodStack) {
            Block.m_49840_((Level)this.ctx.m_43725_(), (BlockPos)this.ctx.m_8083_(), (ItemStack)foodStack);
        }

        @Override
        public void addExp(int i) {
            ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.ctx.m_43725_()), (Vec3)Vec3.m_82512_((Vec3i)this.ctx.m_8083_()), (int)i);
        }
    }
}

