/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.block;

import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.item.CuisineSkilletItem;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.init.data.CDConfig;
import dev.xkmc.cuisinedelight.init.data.LangData;
import dev.xkmc.cuisinedelight.init.registrate.CDBlocks;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import dev.xkmc.l2serial.util.Wrappers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.SkilletBlock;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class CuisineSkilletBlock
extends SkilletBlock {
    public CuisineSkilletBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof CuisineSkilletBlockEntity) {
            CuisineSkilletBlockEntity be = (CuisineSkilletBlockEntity)tileEntity;
            ItemStack heldStack = player.m_21120_(hand);
            IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(heldStack);
            if (config != null) {
                if (!be.canCook()) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.m_240418_((Component)LangData.MSG_NO_HEAT.get(new Object[0]), true);
                    }
                    return InteractionResult.FAIL;
                }
                if (be.cookingData.contents.size() >= (Integer)CDConfig.COMMON.maxIngredient.get()) {
                    if (!level.m_5776_()) {
                        ((ServerPlayer)player).m_240418_((Component)LangData.MSG_FULL.get(new Object[0]), true);
                    }
                    return InteractionResult.FAIL;
                }
                if (!level.f_46443_) {
                    int count = 1 + be.baseItem.getEnchantmentLevel(Enchantments.f_44984_);
                    if (be.slowCook()) {
                        be.cookingData.setSpeed(0.5f);
                    }
                    ItemStack add = heldStack.m_41620_(count);
                    be.cookingData.addItem(add, level.m_46467_());
                    ItemStack remain = add.getCraftingRemainingItem();
                    remain.m_41764_(add.m_41613_());
                    player.m_150109_().m_150079_(remain);
                    be.sync();
                } else {
                    CuisineSkilletItem.playSound(player, level, (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof CuisineSkilletBlockEntity) {
                CuisineSkilletBlockEntity be = (CuisineSkilletBlockEntity)tileEntity;
                Containers.m_19010_((Level)level, (BlockPos)pos, be.getItems());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CuisineSkilletBlockEntity) {
            CuisineSkilletBlockEntity be = (CuisineSkilletBlockEntity)blockEntity;
            return be.toItemStack();
        }
        return CDItems.SKILLET.asStack();
    }

    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        CuisineSkilletBlockEntity skilletEntity;
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof CuisineSkilletBlockEntity && (skilletEntity = (CuisineSkilletBlockEntity)tileEntity).isCooking()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (rand.m_188503_(10) == 0) {
                level.m_7785_(x, y, z, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get(), SoundSource.BLOCKS, 0.4f, rand.m_188501_() * 0.2f + 0.9f, false);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return CDBlocks.BE_SKILLET.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == CDBlocks.BE_SKILLET.get() ? (BlockEntityTicker)Wrappers.cast(CuisineSkilletBlock.getTicker()) : null;
    }

    private static BlockEntityTicker<CuisineSkilletBlockEntity> getTicker() {
        return (level, pos, state, be) -> be.tick(level, pos, state);
    }
}

