/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class WarpCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (FTBEConfig.WARP.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"warp").requires((Predicate)FTBEConfig.WARP)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(WarpCommands.getWarpSuggestions((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(context -> WarpCommands.warp(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setwarp").requires(FTBEConfig.WARP.enabledAndOp())).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> WarpCommands.setWarp(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"delwarp").requires(FTBEConfig.WARP.enabledAndOp())).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(WarpCommands.getWarpSuggestions((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(context -> WarpCommands.deleteWarp(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"listwarps").requires((Predicate)FTBEConfig.WARP)).executes(context -> WarpCommands.listWarps((CommandSourceStack)context.getSource())));
        }
    }

    public static Set<String> getWarpSuggestions(CommandContext<CommandSourceStack> context) {
        return FTBEWorldData.instance.warpManager().getNames();
    }

    public static int warp(ServerPlayer player, String name) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> FTBEWorldData.instance.warpManager().teleportTo(name, player, data.warpTeleporter).runCommand(player)).orElse(0);
    }

    public static int setWarp(ServerPlayer player, String name) {
        FTBEWorldData.instance.warpManager().addDestination(name, new TeleportPos((Entity)player), player);
        player.m_5661_((Component)Component.m_237113_((String)"Warp set!"), false);
        return 1;
    }

    public static int deleteWarp(ServerPlayer player, String name) {
        if (FTBEWorldData.instance.warpManager().deleteDestination(name.toLowerCase())) {
            player.m_5661_((Component)Component.m_237113_((String)"Warp deleted!"), false);
            return 1;
        }
        player.m_5661_((Component)Component.m_237113_((String)"Warp not found!"), false);
        return 0;
    }

    public static int listWarps(CommandSourceStack source) {
        if (FTBEWorldData.instance.warpManager().getNames().isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"None"), false);
        } else {
            TeleportPos origin = new TeleportPos((ResourceKey<Level>)source.m_81372_().m_46472_(), BlockPos.m_274446_((Position)source.m_81371_()));
            FTBEWorldData.instance.warpManager().destinations().forEach(entry -> source.m_288197_(() -> Component.m_237113_((String)(entry.name() + ": " + entry.destination().distanceString(origin))), false));
        }
        return 1;
    }
}

