/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.worldgen.feature.wormroot;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.MultifaceGrowthFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration;
import net.yirmiri.dungeonsdelight.common.block.WormrootsStalkBlock;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;

public class WormrootFeature
extends Feature<MultifaceGrowthConfiguration> {
    public WormrootFeature(Codec<MultifaceGrowthConfiguration> context) {
        super(context);
    }

    private boolean canReplace(WorldGenLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() || level.m_8055_(pos).m_247087_();
    }

    private void placeBlock(WorldGenLevel level, BlockPos pos, BlockState state) {
        if (this.canReplace(level, pos)) {
            if (state.m_60713_((Block)DDBlocks.WORMROOT_STALK.get())) {
                this.m_5974_((LevelWriter)level, pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)WormrootsStalkBlock.NORTH, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_122012_()).m_60713_((Block)DDBlocks.WORMROOT_STALK.get())))).m_61124_((Property)WormrootsStalkBlock.EAST, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_122029_()).m_60713_((Block)DDBlocks.WORMROOT_STALK.get())))).m_61124_((Property)WormrootsStalkBlock.SOUTH, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_122019_()).m_60713_((Block)DDBlocks.WORMROOT_STALK.get())))).m_61124_((Property)WormrootsStalkBlock.WEST, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_122024_()).m_60713_((Block)DDBlocks.WORMROOT_STALK.get())))).m_61124_((Property)WormrootsStalkBlock.UP, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_7494_()).m_60713_((Block)DDBlocks.WORMROOT_STALK.get())))).m_61124_((Property)WormrootsStalkBlock.DOWN, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_7495_()).m_60713_((Block)DDBlocks.WORMROOT_STALK.get()))));
                for (Direction direction : Direction.values()) {
                    if (!level.m_8055_(pos.m_121945_(direction)).m_60713_((Block)DDBlocks.WORMROOT_STALK.get())) continue;
                    this.m_5974_((LevelWriter)level, pos.m_121945_(direction), (BlockState)level.m_8055_(pos.m_121945_(direction)).m_61124_((Property)WormrootsStalkBlock.DIRECTION_TO_PROPERTY.get(direction.m_122424_()), (Comparable)Boolean.valueOf(true)));
                }
            } else {
                this.m_5974_((LevelWriter)level, pos, state);
            }
        }
    }

    private void replaceStonePlace(WorldGenLevel level, BlockPos pos, BlockState state) {
        if (level.m_8055_(pos).m_204336_(BlockTags.f_13061_)) {
            this.m_5974_((LevelWriter)level, pos, state);
        }
    }

    private boolean placeMouthBranch(WorldGenLevel level, BlockPos pos, Direction direction, RandomSource random) {
        if (random.m_188499_()) {
            if (this.canReplace(level, pos.m_121945_(direction)) && this.canReplace(level, pos.m_121945_(direction).m_7495_())) {
                this.placeBlock(level, pos.m_121945_(direction), ((Block)DDBlocks.WORMROOT_STALK.get()).m_49966_());
                this.placeBlock(level, pos.m_121945_(direction).m_7495_(), ((Block)DDBlocks.WORMOUTH.get()).m_49966_());
                return true;
            }
        } else if (this.canReplace(level, pos.m_121945_(direction)) && this.canReplace(level, pos.m_5484_(direction, 2)) && this.canReplace(level, pos.m_5484_(direction, 2).m_7495_())) {
            this.placeBlock(level, pos.m_121945_(direction), (BlockState)((Block)DDBlocks.WORMROOT_STALK.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)direction.m_122434_()));
            this.placeBlock(level, pos.m_5484_(direction, 2), ((Block)DDBlocks.WORMROOT_STALK.get()).m_49966_());
            this.placeBlock(level, pos.m_5484_(direction, 2).m_7495_(), ((Block)DDBlocks.WORMOUTH.get()).m_49966_());
            return true;
        }
        return false;
    }

    private void placeEndMouth(WorldGenLevel level, BlockPos pos, RandomSource random) {
        this.placeBlock(level, pos, ((Block)DDBlocks.WORMROOT_STALK.get()).m_49966_());
        this.placeBlock(level, pos.m_7494_(), ((Block)DDBlocks.WORMROOT_STALK.get()).m_49966_());
        this.placeMouthBranch(level, pos.m_7494_(), Direction.Plane.HORIZONTAL.m_235690_(random), random);
    }

    public boolean m_142674_(FeaturePlaceContext<MultifaceGrowthConfiguration> context) {
        int j;
        int i;
        RandomSource random = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_().m_6630_(2);
        Direction mainBranchDir = Direction.Plane.HORIZONTAL.m_235690_(random);
        int firstHeight = random.m_216339_(3, 4);
        int secondHeight = random.m_216339_(2, 3);
        float mouthBranchChance = 0.0f;
        BlockState upDownState = ((Block)DDBlocks.WORMROOT_STALK.get()).m_49966_();
        this.replaceStonePlace(level, context.m_159777_().m_7494_().m_7495_(), ((Block)DDBlocks.WORMROOTS_BLOCK.get()).m_49966_());
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                if (!random.m_188499_()) continue;
                this.replaceStonePlace(level, context.m_159777_().m_7494_().m_7918_(i, -1, j), ((Block)DDBlocks.WORMROOTS_BLOCK.get()).m_49966_());
            }
        }
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                if (!random.m_188499_()) continue;
                this.replaceStonePlace(level, context.m_159777_().m_7494_().m_7918_(i, -1, j), Blocks.f_50546_.m_49966_());
            }
        }
        level.m_7731_(context.m_159777_().m_7494_(), upDownState, 2);
        for (i = 0; i < firstHeight; ++i) {
            this.placeBlock(level, pos.m_6630_(i), upDownState);
            if (random.m_188501_() < mouthBranchChance && i > 0) {
                ArrayList dirs = new ArrayList(Direction.Plane.HORIZONTAL.m_122557_().toList());
                dirs.remove(mainBranchDir);
                dirs.remove(mainBranchDir.m_122424_());
                Direction direction = (Direction)dirs.get(random.m_216339_(0, dirs.size()));
                if (!this.placeMouthBranch(level, pos.m_6630_(i), direction, random)) continue;
                mouthBranchChance = 0.0f;
                continue;
            }
            mouthBranchChance += 0.3f;
        }
        pos = pos.m_6630_(firstHeight - 1);
        if (random.m_188499_()) {
            int i2;
            firstOffset = random.m_216339_(2, 3);
            for (i2 = 1; i2 < firstOffset; ++i2) {
                this.placeBlock(level, pos.m_5484_(mainBranchDir, i2), (BlockState)upDownState.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)mainBranchDir.m_122434_()));
            }
            pos = pos.m_5484_(mainBranchDir, firstOffset);
            for (i2 = 0; i2 < secondHeight; ++i2) {
                this.placeBlock(level, pos.m_6630_(i2), upDownState);
                if (random.m_188501_() < mouthBranchChance) {
                    if (!this.placeMouthBranch(level, pos.m_6630_(i2), Direction.Plane.HORIZONTAL.m_235690_(random), random)) continue;
                    mouthBranchChance = 0.0f;
                    continue;
                }
                mouthBranchChance += 0.4f;
            }
            this.placeEndMouth(level, pos.m_6630_(secondHeight), random);
        } else {
            firstOffset = random.m_216339_(2, 3);
            for (int i3 = 1; i3 < firstOffset; ++i3) {
                this.placeBlock(level, pos.m_5484_(mainBranchDir, i3), (BlockState)upDownState.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)mainBranchDir.m_122434_()));
            }
            BlockPos firstPos = pos.m_5484_(mainBranchDir, firstOffset);
            for (int i4 = 0; i4 < secondHeight; ++i4) {
                this.placeBlock(level, firstPos.m_6630_(i4), upDownState);
                if (random.m_188501_() < mouthBranchChance) {
                    if (!this.placeMouthBranch(level, firstPos.m_6630_(i4), Direction.Plane.HORIZONTAL.m_235690_(random), random)) continue;
                    mouthBranchChance = 0.0f;
                    continue;
                }
                mouthBranchChance += 0.4f;
            }
            this.placeEndMouth(level, firstPos.m_6630_(secondHeight), random);
            boolean below = random.m_188499_();
            int secondOffset = random.m_216339_(2, 3);
            for (int i5 = 1; i5 < secondOffset; ++i5) {
                this.placeBlock(level, pos.m_5484_(mainBranchDir.m_122424_(), i5).m_6625_(below ? 2 : 1), (BlockState)upDownState.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)mainBranchDir.m_122434_()));
            }
            BlockPos secondPos = pos.m_5484_(mainBranchDir.m_122424_(), secondOffset).m_6625_(below ? 2 : 1);
            for (int i6 = 0; i6 < secondHeight; ++i6) {
                this.placeBlock(level, secondPos.m_6630_(i6), upDownState);
                if (random.m_188501_() < mouthBranchChance) {
                    if (!this.placeMouthBranch(level, secondPos.m_6630_(i6), Direction.Plane.HORIZONTAL.m_235690_(random), random)) continue;
                    mouthBranchChance = 0.0f;
                    continue;
                }
                mouthBranchChance += 0.4f;
            }
            this.placeEndMouth(level, secondPos.m_6630_(secondHeight), random);
        }
        for (i = 0; i < 6; ++i) {
            FeaturePlaceContext context1 = new FeaturePlaceContext(context.m_190935_(), context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_().m_7918_(random.m_216339_(-2, 2), 0, random.m_216339_(-2, 2)), (FeatureConfiguration)((MultifaceGrowthConfiguration)context.m_159778_()));
            this.placeTendrils((FeaturePlaceContext<MultifaceGrowthConfiguration>)context1);
        }
        return true;
    }

    public boolean placeTendrils(FeaturePlaceContext<MultifaceGrowthConfiguration> p_225165_) {
        WorldGenLevel worldgenlevel = p_225165_.m_159774_();
        BlockPos blockpos = p_225165_.m_159777_();
        RandomSource randomsource = p_225165_.m_225041_();
        MultifaceGrowthConfiguration multifacegrowthconfiguration = (MultifaceGrowthConfiguration)p_225165_.m_159778_();
        if (!WormrootFeature.isAirOrWater(worldgenlevel.m_8055_(blockpos))) {
            return false;
        }
        List list = multifacegrowthconfiguration.m_225399_(randomsource);
        if (MultifaceGrowthFeature.m_225157_((WorldGenLevel)worldgenlevel, (BlockPos)blockpos, (BlockState)worldgenlevel.m_8055_(blockpos), (MultifaceGrowthConfiguration)multifacegrowthconfiguration, (RandomSource)randomsource, (List)list)) {
            return true;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockpos.m_122032_();
        block0: for (Direction direction : list) {
            blockpos$mutableblockpos.m_122190_((Vec3i)blockpos);
            List list1 = multifacegrowthconfiguration.m_225401_(randomsource, direction.m_122424_());
            for (int i = 0; i < multifacegrowthconfiguration.f_225383_; ++i) {
                blockpos$mutableblockpos.m_122159_((Vec3i)blockpos, direction);
                BlockState blockstate = worldgenlevel.m_8055_((BlockPos)blockpos$mutableblockpos);
                if (!WormrootFeature.isAirOrWater(blockstate) && !blockstate.m_60713_((Block)multifacegrowthconfiguration.f_225382_)) continue block0;
                if (!MultifaceGrowthFeature.m_225157_((WorldGenLevel)worldgenlevel, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate, (MultifaceGrowthConfiguration)multifacegrowthconfiguration, (RandomSource)randomsource, (List)list1)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAirOrWater(BlockState p_225167_) {
        return p_225167_.m_60795_() || p_225167_.m_60713_(Blocks.f_49990_);
    }
}

