/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SlimeFoodItem
extends Item {
    private final boolean hasFoodEffectTooltip;
    private final float chance;

    public SlimeFoodItem(Item.Properties properties, float chance, boolean hasFoodEffectTooltip) {
        super(properties);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.chance = chance;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        if (!level.f_46443_) {
            this.affectConsumer(stack, level, consumer);
        }
        boolean successfulChance = level.f_46441_.m_188501_() < this.chance;
        ItemStack containerStack = stack.getCraftingRemainingItem();
        if (stack.m_41614_()) {
            super.m_5922_(stack, level, consumer);
            if (consumer instanceof Player && successfulChance) {
                player = (Player)consumer;
                player.m_150109_().m_36054_(new ItemStack((ItemLike)this, 1));
                player.m_5496_(SoundEvents.f_12387_, 0.7f, 0.7f);
            }
        } else {
            Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, stack);
            }
            if (player != null) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
        }
        if (stack.m_41619_() && !successfulChance) {
            return containerStack;
        }
        if (consumer instanceof Player) {
            player = (Player)consumer;
            if (!(successfulChance || ((Player)consumer).m_150110_().f_35937_ || player.m_150109_().m_36054_(containerStack))) {
                player.m_36176_(containerStack, false);
            }
        }
        return stack;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            int percent = Math.round(this.chance * 100.0f);
            tooltip.add((Component)Component.m_237113_((String)(percent + "% ")).m_7220_((Component)Component.m_237115_((String)"farmersdelight.tooltip.chance_to_not_consume")).m_130940_(ChatFormatting.BLUE));
        }
        if (this.hasFoodEffectTooltip) {
            TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip, (float)1.0f);
        }
    }
}

