/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.util;

import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CustomPortalHelper {
    public static boolean isInstanceOfCustomPortal(Level world, BlockPos pos) {
        return CustomPortalHelper.isInstanceOfCustomPortal(world.m_8055_(pos));
    }

    public static boolean isInstanceOfCustomPortal(BlockState state) {
        return state.m_60734_() instanceof CustomPortalBlock;
    }

    public static boolean isInstanceOfPortalFrame(Level world, BlockPos pos) {
        if (world.m_46739_(pos)) {
            return CustomPortalApiRegistry.isRegisteredFrameBlock(world.m_8055_(pos));
        }
        return false;
    }

    public static Block getPortalBase(Level world, BlockPos pos) {
        if (CustomPortalHelper.isInstanceOfCustomPortal(world, pos)) {
            return ((CustomPortalBlock)world.m_8055_(pos).m_60734_()).getPortalBase(world, pos);
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos)) {
            return world.m_8055_(pos).m_60734_();
        }
        return Blocks.f_50016_;
    }

    public static Block getPortalBaseDefault(Level world, BlockPos pos) {
        if (CustomPortalHelper.isInstanceOfCustomPortal(world, pos)) {
            Direction.Axis axis = CustomPortalHelper.getAxisFrom(world.m_8055_(pos));
            if (axis != Direction.Axis.Y) {
                if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.m_7495_())) {
                    return world.m_8055_(pos.m_7495_()).m_60734_();
                }
                if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.m_7494_())) {
                    return world.m_8055_(pos.m_7494_()).m_60734_();
                }
            } else {
                axis = Direction.Axis.Z;
            }
            if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.m_5487_(axis, -1))) {
                return world.m_8055_(pos.m_5487_(axis, -1)).m_60734_();
            }
            if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.m_5487_(axis, 1))) {
                return world.m_8055_(pos.m_5487_(axis, 1)).m_60734_();
            }
            return CustomPortalHelper.getPortalBaseDefault(world, pos.m_5487_(axis, -1));
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos)) {
            return world.m_8055_(pos).m_60734_();
        }
        return Blocks.f_50016_;
    }

    public static BlockPos getClosestFrameBlock(Level world, BlockPos pos) {
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.m_7495_())) {
            return pos.m_7495_();
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.m_122029_())) {
            return pos.m_122029_();
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.m_122024_())) {
            return pos.m_122024_();
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.m_122012_())) {
            return pos.m_122012_();
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.m_122019_())) {
            return pos.m_122019_();
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.m_7494_())) {
            return pos.m_7494_();
        }
        return pos;
    }

    public static Direction.Axis getAxisFrom(BlockState state) {
        if (state.m_60734_() instanceof CustomPortalBlock) {
            return (Direction.Axis)state.m_61143_(CustomPortalBlock.AXIS);
        }
        if (state.m_60734_() instanceof NetherPortalBlock) {
            return (Direction.Axis)state.m_61143_((Property)NetherPortalBlock.f_54904_);
        }
        return Direction.Axis.X;
    }

    public static BlockState blockWithAxis(BlockState state, Direction.Axis axis) {
        if (state.m_60734_() instanceof CustomPortalBlock) {
            return (BlockState)state.m_61124_(CustomPortalBlock.AXIS, (Comparable)axis);
        }
        return state;
    }
}

