/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal;

import java.util.Optional;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;

public class PortalPlacer {
    public static boolean attemptPortalLight(Level world, BlockPos portalPos, PortalIgnitionSource ignitionSource) {
        return PortalPlacer.attemptPortalLight(world, portalPos, CustomPortalHelper.getClosestFrameBlock(world, portalPos), ignitionSource);
    }

    public static boolean attemptPortalLight(Level world, BlockPos portalPos, BlockPos framePos, PortalIgnitionSource ignitionSource) {
        Block foundationBlock = world.m_8055_(framePos).m_60734_();
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(foundationBlock);
        if (link == null || !link.doesIgnitionMatch(ignitionSource) || !link.canLightInDim(world.m_46472_().m_135782_())) {
            return false;
        }
        return PortalPlacer.createPortal(link, world, portalPos, foundationBlock);
    }

    private static boolean createPortal(PortalLink link, Level world, BlockPos pos, Block foundationBlock) {
        Optional<PortalFrameTester> optional = link.getFrameTester().createInstanceOfPortalFrameTester().getNewPortal((LevelAccessor)world, pos, Direction.Axis.X, foundationBlock);
        if (optional.isPresent()) {
            if (optional.get().isRequestedSize(link.forcedWidth, link.forcedHeight)) {
                optional.get().lightPortal(foundationBlock);
            }
            return true;
        }
        return false;
    }

    public static Optional<BlockUtil.FoundRectangle> createDestinationPortal(Level world, BlockPos blockPos, BlockState frameBlock, Direction.Axis axis) {
        WorldBorder worldBorder = world.m_6857_();
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock.m_60734_());
        PortalFrameTester portalFrameTester = link.getFrameTester().createInstanceOfPortalFrameTester();
        for (BlockPos.MutableBlockPos mutable : BlockPos.m_121935_((BlockPos)blockPos, (int)16, (Direction)Direction.WEST, (Direction)Direction.SOUTH)) {
            BlockPos testingPos = mutable.m_7949_();
            if (!worldBorder.m_61937_(testingPos)) continue;
            BlockPos pos = null;
            for (int solidY = Math.min(world.m_151558_(), world.m_141937_() + world.m_6042_().f_156648_()) - 5; solidY >= 3; --solidY) {
                BlockPos testRect;
                if (!PortalPlacer.canHoldPortal(world.m_8055_(testingPos.m_175288_(solidY))) || (testRect = portalFrameTester.doesPortalFitAt(world, testingPos.m_175288_(solidY + 1), axis)) == null) continue;
                pos = testRect;
                break;
            }
            if (pos == null) continue;
            portalFrameTester.createPortal(world, pos, frameBlock, axis);
            return Optional.of(portalFrameTester.getRectangle());
        }
        portalFrameTester.createPortal(world, blockPos, frameBlock, axis);
        return Optional.of(portalFrameTester.getRectangle());
    }

    private static boolean canHoldPortal(BlockState state) {
        return state.m_280296_();
    }
}

