/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.endertrigon.common.init;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import nonamecrackers2.endertrigon.common.config.EnderTrigonConfig;
import nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase.DragonCarryPlayerPhase;
import nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase.DragonChargeUpPhase;
import nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase.DragonCrashPlayerPhase;
import nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase.DragonDiveBombPlayerPhase;
import nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase.DragonSnatchPlayerPhase;
import nonamecrackers2.endertrigon.mixin.IMixinEnderDragonPhase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnderTrigonDragonPhases {
    public static final Logger LOGGER = LogManager.getLogger((String)"endertrigon/EnderTrigonDragonPhases");
    public static final Map<String, Class<? extends DragonPhaseInstance>> CUSTOM_DRAGON_PHASES = ((ImmutableMap.Builder)Util.m_137469_((Object)ImmutableMap.builder(), map -> {
        map.put((Object)"ChargeUp", DragonChargeUpPhase.class);
        map.put((Object)"SnatchPlayer", DragonSnatchPlayerPhase.class);
        map.put((Object)"CarryPlayer", DragonCarryPlayerPhase.class);
        map.put((Object)"CrashPlayer", DragonCrashPlayerPhase.class);
        map.put((Object)"DiveBombPlayer", DragonDiveBombPlayerPhase.class);
    })).build();
    private static Map<String, EnderDragonPhase<?>> builtPhases;

    public static void register() {
        if (builtPhases != null) {
            throw new IllegalStateException("Dragon phases are already registered!");
        }
        builtPhases = (Map)CUSTOM_DRAGON_PHASES.entrySet().stream().filter(e -> EnderTrigonConfig.COMMON.enabledCustomDragonPhases.get(e.getKey()).getAsBoolean()).map(e -> Map.entry((String)e.getKey(), EnderTrigonDragonPhases.create((Class)e.getValue(), (String)e.getKey()))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        LOGGER.debug("Registered custom dragon phases:");
        for (Map.Entry<String, Class<? extends DragonPhaseInstance>> entry : CUSTOM_DRAGON_PHASES.entrySet()) {
            LOGGER.debug("Enabled: " + (builtPhases.get(entry.getKey()) != null ? "TRUE" : "FALSE") + " ---> " + entry.getKey());
        }
    }

    public static <T extends DragonPhaseInstance> Optional<EnderDragonPhase<T>> getPhase(String name) {
        EnderTrigonDragonPhases.assertValidId(name);
        if (builtPhases.containsKey(name)) {
            return Optional.of(builtPhases.get(name));
        }
        return Optional.empty();
    }

    public static boolean isPhase(String id, EnderDragonPhase<? extends DragonPhaseInstance> phase) {
        EnderTrigonDragonPhases.assertValidId(id);
        if (!builtPhases.containsKey(id)) {
            return false;
        }
        return builtPhases.get(id) == phase;
    }

    public static boolean isEnabled(String id) {
        EnderTrigonDragonPhases.assertValidId(id);
        return builtPhases.containsKey(id);
    }

    private static void assertValidId(String id) {
        if (!CUSTOM_DRAGON_PHASES.containsKey(id)) {
            throw new IllegalArgumentException("'" + id + "' is not a valid custom dragon phase id");
        }
    }

    private static <T extends DragonPhaseInstance> EnderDragonPhase<T> create(Class<T> instanceClass, String name) {
        return IMixinEnderDragonPhase.callCreate(instanceClass, name);
    }
}

