/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.item_filtering;

import dev.ftb.mods.ftbquests.api.ItemFilterAdapter;
import dev.ftb.mods.ftbquests.integration.item_filtering.DisplayStacksCache;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public enum ItemMatchingSystem {
    INSTANCE;

    private final List<ItemFilterAdapter> adapters = new CopyOnWriteArrayList<ItemFilterAdapter>();

    public void registerFilterAdapter(ItemFilterAdapter adapter) {
        this.adapters.add(adapter);
    }

    public boolean isItemFilter(ItemStack stack) {
        return this.getFilterAdapter(stack).isPresent();
    }

    public Optional<ItemFilterAdapter> getFilterAdapter(ItemStack stack) {
        return this.adapters.stream().filter(adapter -> adapter.isFilterStack(stack)).findFirst();
    }

    public boolean doesItemMatch(ItemStack filterStack, ItemStack toCheck, boolean matchNBT, boolean fuzzyNBT) {
        return this.getFilterAdapter(filterStack).map(adapter -> adapter.doesItemMatch(filterStack, toCheck)).orElse(this.areItemStacksEqual(filterStack, toCheck, matchNBT, fuzzyNBT));
    }

    public List<ItemStack> getAllMatchingStacks(ItemStack filterStack) {
        ArrayList res = new ArrayList();
        this.adapters.forEach(adapter -> {
            if (adapter.isFilterStack(filterStack)) {
                res.addAll(DisplayStacksCache.getCachedDisplayStacks(filterStack, adapter));
            }
        });
        return res.isEmpty() ? List.of(filterStack) : res;
    }

    private boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB, boolean matchNBT, boolean fuzzyNBT) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA.m_41720_() != stackB.m_41720_()) {
            return false;
        }
        if (!stackA.m_41782_() && !stackB.m_41782_()) {
            return true;
        }
        return !matchNBT || NBTUtils.compareNbt((Tag)stackA.m_41783_(), (Tag)stackB.m_41783_(), fuzzyNBT, true);
    }

    public Collection<ItemFilterAdapter> adapters() {
        return Collections.unmodifiableCollection(this.adapters);
    }
}

