/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct.magnet_card;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeableItem;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.networking.ServerNetworkManager;
import de.mari_023.ae2wtlib.networking.s2c.RestockAmountPacket;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetSettings;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MagnetHandler {
    private static final WeakHashMap<ServerPlayer, Integer> players = new WeakHashMap();

    public static void handle(ServerPlayer player, ItemStack terminal) {
        if (players.containsKey(player) && players.get(player) == MagnetHandler.getTick(player)) {
            return;
        }
        MagnetHandler.sendRestockAble(player, terminal);
        MagnetHandler.handleMagnet((Player)player, terminal);
        players.put(player, MagnetHandler.getTick(player));
    }

    private static int getTick(ServerPlayer player) {
        if (player.m_20194_() == null) {
            return -1;
        }
        return player.m_20194_().m_129921_();
    }

    private static void sendRestockAble(ServerPlayer player, ItemStack terminal) {
        if (player.m_7500_()) {
            return;
        }
        if (!ItemWT.getBoolean(terminal, "restock")) {
            return;
        }
        MagnetHandler.sendRestockAble(player);
    }

    private static void sendRestockAble(ServerPlayer player) {
        CraftingTerminalHandler handler = CraftingTerminalHandler.getCraftingTerminalHandler((Player)player);
        if (!ItemWT.getBoolean(handler.getCraftingTerminal(), "restock") || !handler.inRange()) {
            return;
        }
        HashMap<Item, Long> items = new HashMap<Item, Long>();
        if (handler.getTargetGrid() == null) {
            return;
        }
        KeyCounter storageList = handler.getTargetGrid().getStorageService().getCachedInventory();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || items.containsKey(stack.m_41720_())) continue;
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            if (key == null) {
                items.put(stack.m_41720_(), 0L);
                continue;
            }
            items.put(stack.m_41720_(), storageList.get((AEKey)key));
        }
        ServerNetworkManager.sendToClient(player, new RestockAmountPacket(items));
    }

    private static void handleMagnet(Player player, ItemStack terminal) {
        if (player.m_6144_()) {
            return;
        }
        if (MagnetHandler.getMagnetSettings(terminal).isDisabled()) {
            return;
        }
        MagnetHandler.handleMagnet(player);
    }

    private static void handleMagnet(Player player) {
        CraftingTerminalHandler ctHandler = CraftingTerminalHandler.getCraftingTerminalHandler(player);
        if (MagnetHandler.getMagnetSettings(ctHandler.getCraftingTerminal()).isDisabled()) {
            return;
        }
        MagnetHost magnetHost = ctHandler.getMagnetHost();
        if (magnetHost == null) {
            return;
        }
        List entityItems = player.m_9236_().m_6443_(ItemEntity.class, player.m_20191_().m_82400_(AE2wtlibConfig.INSTANCE.magnetCardRange()), EntitySelector.f_20402_);
        for (ItemEntity entityItemNearby : entityItems) {
            AEItemKey item = AEItemKey.of((ItemStack)entityItemNearby.m_32055_());
            if (item == null || !magnetHost.getPickupFilter().matchesFilter((AEKey)item, magnetHost.getPickupMode()) || Platform.preventRemoteMovement(entityItemNearby)) continue;
            entityItemNearby.m_6123_(player);
        }
    }

    public static void saveMagnetSettings(ItemStack terminal, MagnetSettings magnetSettings) {
        IUpgradeableItem upgradeableItem;
        Item item = terminal.m_41720_();
        if (item instanceof IUpgradeableItem && (upgradeableItem = (IUpgradeableItem)item).getUpgrades(terminal).isInstalled((ItemLike)AE2wtlib.MAGNET_CARD)) {
            terminal.m_41784_().m_128365_("magnet_settings", (Tag)magnetSettings.toTag());
        }
    }

    public static MagnetSettings getMagnetSettings(ItemStack terminal) {
        IUpgradeableItem upgradeableItem;
        Item item = terminal.m_41720_();
        if (item instanceof IUpgradeableItem && (upgradeableItem = (IUpgradeableItem)item).getUpgrades(terminal).isInstalled((ItemLike)AE2wtlib.MAGNET_CARD)) {
            return new MagnetSettings((CompoundTag)terminal.m_41784_().m_128423_("magnet_settings"));
        }
        return new MagnetSettings();
    }
}

