/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.furniture.refurbished.network.play.ClientPlayHandler;
import com.mrcrayfish.furniture.refurbished.network.play.ServerPlayHandler;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;

public final class MessageWorkbench {

    public static class SearchNeighbours
    extends PlayMessage<SearchNeighbours> {
        public void encode(SearchNeighbours message, FriendlyByteBuf buffer) {
        }

        public SearchNeighbours decode(FriendlyByteBuf buffer) {
            return new SearchNeighbours();
        }

        public void handle(SearchNeighbours message, MessageContext context) {
            context.execute(() -> ServerPlayHandler.handleMessageWorkbenchSearchNeighbours(message, context.getPlayer()));
            context.setHandled(true);
        }
    }

    public static class SelectRecipe
    extends PlayMessage<SelectRecipe> {
        private int index;

        public SelectRecipe() {
        }

        public SelectRecipe(int index) {
            this.index = index;
        }

        public void encode(SelectRecipe message, FriendlyByteBuf buf) {
            buf.m_130130_(message.index);
        }

        public SelectRecipe decode(FriendlyByteBuf buf) {
            return new SelectRecipe(buf.m_130242_());
        }

        public void handle(SelectRecipe message, MessageContext context) {
            context.execute(() -> ServerPlayHandler.handleMessageWorkbenchSelectRecipe(message, context.getPlayer()));
            context.setHandled(true);
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class ItemCounts
    extends PlayMessage<ItemCounts> {
        private Map<Integer, Integer> counts;

        public ItemCounts() {
        }

        public ItemCounts(Map<Integer, Integer> counts) {
            this.counts = counts;
        }

        public void encode(ItemCounts message, FriendlyByteBuf buffer) {
            buffer.m_130130_(message.counts.size());
            for (Map.Entry<Integer, Integer> entry : message.counts.entrySet()) {
                buffer.writeInt(entry.getKey().intValue());
                buffer.writeInt(entry.getValue().intValue());
            }
        }

        public ItemCounts decode(FriendlyByteBuf buffer) {
            Int2IntOpenHashMap counts = new Int2IntOpenHashMap();
            int size = buffer.m_130242_();
            while (size-- > 0) {
                int itemId = buffer.readInt();
                int count = buffer.readInt();
                counts.put(itemId, count);
            }
            return new ItemCounts((Map<Integer, Integer>)counts);
        }

        public void handle(ItemCounts message, MessageContext context) {
            context.execute(() -> ClientPlayHandler.handleMessageWorkbenchItemCounts(message));
            context.setHandled(true);
        }

        public Map<Integer, Integer> getCounts() {
            return this.counts;
        }
    }
}

