/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeSerializers;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CuttingBoardCombiningRecipe
implements Recipe<Container> {
    public static final int MAX_INGREDIENTS = 5;
    protected final ResourceLocation id;
    protected final NonNullList<Ingredient> ingredients;
    protected final ItemStack result;

    public CuttingBoardCombiningRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack result) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = result;
    }

    public boolean m_5818_(Container container, Level level) {
        for (int i = 0; i < this.ingredients.size() && i < container.m_6643_(); ++i) {
            if (((Ingredient)this.ingredients.get(i)).test(container.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess access) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.CUTTING_BOARD_COMBINING_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.CUTTING_BOARD_COMBINING.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public boolean completelyMatches(Container container) {
        if (this.ingredients.size() <= container.m_6643_()) {
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (((Ingredient)this.ingredients.get(i)).test(container.m_8020_(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient[] ingredients;
        private final ItemStack result;

        public Result(ResourceLocation id, Ingredient[] ingredients, ItemStack result) {
            this.id = id;
            this.ingredients = ingredients;
            this.result = result;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.CUTTING_BOARD_COMBINING_RECIPE.get();
        }

        public void m_7917_(JsonObject object) {
            Serializer.toJson(this, object);
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Builder
    implements RecipeBuilder {
        private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
        private final ItemStack result;

        public Builder(ItemStack result) {
            this.result = result;
        }

        public Builder add(Ingredient ingredient) {
            this.ingredients.add(ingredient);
            return this;
        }

        public RecipeBuilder m_126132_(String name, CriterionTriggerInstance trigger) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support unlocking");
        }

        public RecipeBuilder m_126145_(@Nullable String group) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support setting the group");
        }

        public Item m_142372_() {
            return this.result.m_41720_();
        }

        public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            this.validate(id);
            consumer.accept(new Result(id, (Ingredient[])this.ingredients.toArray(Ingredient[]::new), this.result));
        }

        private void validate(ResourceLocation id) {
            if (this.ingredients.size() < 2) {
                throw new IllegalStateException("Cutting Board combining recipe must have at least 2 input ingredients");
            }
            if (this.ingredients.size() > 5) {
                throw new IllegalStateException("Cutting Board combining recipe only supports up to 5 input ingredients");
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<CuttingBoardCombiningRecipe> {
        public static void toJson(Result result, JsonObject object) {
            JsonArray inputArray = new JsonArray();
            for (Ingredient ingredient : result.ingredients) {
                inputArray.add(ingredient.m_43942_());
            }
            object.add("ingredients", (JsonElement)inputArray);
            object.addProperty("result", BuiltInRegistries.f_257033_.m_7981_((Object)result.result.m_41720_()).toString());
            object.addProperty("count", (Number)result.result.m_41613_());
        }

        public CuttingBoardCombiningRecipe fromJson(ResourceLocation id, JsonObject object) {
            JsonArray inputArray = GsonHelper.m_13933_((JsonObject)object, (String)"ingredients");
            Object[] ingredients = (Ingredient[])StreamSupport.stream(inputArray.spliterator(), false).map(element -> Ingredient.m_288218_((JsonElement)element, (boolean)false)).toArray(Ingredient[]::new);
            String resultString = GsonHelper.m_13906_((JsonObject)object, (String)"result");
            Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(resultString)).orElseThrow(() -> new IllegalStateException("Item: " + resultString + " does not exist"));
            int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
            ItemStack result = new ItemStack((ItemLike)item, count);
            return new CuttingBoardCombiningRecipe(id, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients), result);
        }

        public CuttingBoardCombiningRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int inputCount = buffer.readInt();
            Object[] ingredients = (Ingredient[])IntStream.range(0, inputCount).mapToObj(val -> Ingredient.m_43940_((FriendlyByteBuf)buffer)).toArray(Ingredient[]::new);
            ItemStack result = buffer.m_130267_();
            return new CuttingBoardCombiningRecipe(id, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients), result);
        }

        public void toNetwork(FriendlyByteBuf buffer, CuttingBoardCombiningRecipe recipe) {
            buffer.writeInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
        }
    }
}

