/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.compat.crafttweaker.handlers;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.mrcrayfish.furniture.refurbished.compat.crafttweaker.CustomRecipeComponents;
import com.mrcrayfish.furniture.refurbished.crafting.OvenBakingRecipe;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

@IRecipeHandler.For(value=OvenBakingRecipe.class)
public class OvenBakingRecipeHandler
implements IRecipeHandler<OvenBakingRecipe> {
    public String dumpToCommandString(IRecipeManager<? super OvenBakingRecipe> manager, OvenBakingRecipe recipe) {
        return "%s.addRecipe(%s, %s, %s, %s);".formatted(manager.getCommandString(), StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()), IIngredient.fromIngredient((Ingredient)recipe.getIngredient()).getCommandString(), IItemStack.ofMutable((ItemStack)recipe.getResult()).getCommandString(), recipe.getTime());
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super OvenBakingRecipe> manager, OvenBakingRecipe firstRecipe, U secondRecipe) {
        if (!(secondRecipe instanceof OvenBakingRecipe)) {
            return true;
        }
        OvenBakingRecipe bakingRecipe = (OvenBakingRecipe)secondRecipe;
        return IngredientUtil.canConflict((Ingredient)firstRecipe.getIngredient(), (Ingredient)bakingRecipe.getIngredient());
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super OvenBakingRecipe> manager, OvenBakingRecipe recipe) {
        IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder().with(CustomRecipeComponents.Metadata.PROCESSING_CATEGORY, (Object)recipe.getCategory()).with(BuiltinRecipeComponents.Input.INGREDIENTS, (Object)IIngredient.fromIngredient((Ingredient)recipe.getIngredient())).with(BuiltinRecipeComponents.Output.ITEMS, (Object)IItemStack.ofMutable((ItemStack)recipe.getResult())).with(BuiltinRecipeComponents.Processing.TIME, (Object)recipe.getTime()).build();
        return Optional.of(decomposedRecipe);
    }

    public Optional<OvenBakingRecipe> recompose(IRecipeManager<? super OvenBakingRecipe> manager, ResourceLocation id, IDecomposedRecipe recipe) {
        ProcessingRecipe.Category category = (ProcessingRecipe.Category)((Object)recipe.getOrThrowSingle(CustomRecipeComponents.Metadata.PROCESSING_CATEGORY));
        Ingredient ingredient = ((IIngredient)recipe.getOrThrowSingle(BuiltinRecipeComponents.Input.INGREDIENTS)).asVanillaIngredient();
        ItemStack result = ((IItemStack)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS)).getInternal();
        int time = (Integer)recipe.getOrThrowSingle(BuiltinRecipeComponents.Processing.TIME);
        return Optional.of(new OvenBakingRecipe(id, category, ingredient, result, time));
    }
}

