/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.ICookingBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.StoveBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;

public class StoveContainer
extends CompoundContainer
implements WorldlyContainer {
    private final StoveBlockEntity stove;
    private final ICookingBlock cookingBlock;
    private final Container cookingContainer;
    private final int[][] slots;

    public StoveContainer(StoveBlockEntity stove, ICookingBlock cookingBlock, Container cookingContainer) {
        super((Container)stove, cookingContainer);
        this.stove = stove;
        this.cookingBlock = cookingBlock;
        this.cookingContainer = cookingContainer;
        this.slots = this.generateSlots();
    }

    private int[][] generateSlots() {
        int[][] slots = new int[Direction.values().length][1];
        for (Direction direction : Direction.values()) {
            int[] stoveSlots = this.stove.m_7071_(direction);
            Container container = this.cookingContainer;
            if (container instanceof WorldlyContainer) {
                WorldlyContainer worldlyContainer = (WorldlyContainer)container;
                int[] cookingSlots = worldlyContainer.m_7071_(direction);
                slots[direction.m_122411_()] = this.combineSlots(stoveSlots, cookingSlots, this.stove.m_6643_());
                continue;
            }
            slots[direction.m_122411_()] = stoveSlots;
        }
        return slots;
    }

    private int[] combineSlots(int[] a, int[] b, int indexOffset) {
        int[] copy = new int[b.length];
        System.arraycopy(b, 0, copy, 0, b.length);
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = copy[i] + indexOffset;
        }
        int[] c = new int[a.length + copy.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(copy, 0, c, a.length, copy.length);
        return c;
    }

    public boolean isValid() {
        return !this.stove.m_58901_() && !this.cookingBlock.getBlockEntity().m_58901_();
    }

    public int[] m_7071_(Direction direction) {
        return this.slots[direction.m_122411_()];
    }

    public boolean m_7155_(int slotIndex, ItemStack stack, @Nullable Direction direction) {
        if (slotIndex >= this.stove.m_6643_()) {
            Container container = this.cookingContainer;
            if (container instanceof WorldlyContainer) {
                WorldlyContainer worldlyContainer = (WorldlyContainer)container;
                return worldlyContainer.m_7155_(slotIndex - this.stove.m_6643_(), stack, direction);
            }
            return this.cookingContainer.m_7013_(slotIndex - this.stove.m_6643_(), stack);
        }
        return this.stove.m_7155_(slotIndex, stack, direction);
    }

    public boolean m_7157_(int slotIndex, ItemStack stack, Direction direction) {
        if (slotIndex >= this.stove.m_6643_()) {
            Container container = this.cookingContainer;
            if (container instanceof WorldlyContainer) {
                WorldlyContainer worldlyContainer = (WorldlyContainer)container;
                return worldlyContainer.m_7157_(slotIndex - this.stove.m_6643_(), stack, direction);
            }
            return this.cookingContainer.m_271862_(this.cookingContainer, slotIndex - this.stove.m_6643_(), stack);
        }
        return this.stove.m_7157_(slotIndex, stack, direction);
    }

    public boolean m_271862_(Container container, int slotIndex, ItemStack stack) {
        if (slotIndex >= this.stove.m_6643_()) {
            return this.cookingContainer.m_271862_(this.cookingContainer, slotIndex - this.stove.m_6643_(), stack);
        }
        return this.stove.m_271862_((Container)this.stove, slotIndex, stack);
    }
}

