/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.s2c;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.item.upgrade.VehicleUpgrade;
import immersive_aircraft.item.upgrade.VehicleUpgradeRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class VehicleUpgradesMessage
extends Message {
    private final Map<Item, VehicleUpgrade> upgrades;

    public VehicleUpgradesMessage() {
        this.upgrades = VehicleUpgradeRegistry.INSTANCE.getAll();
    }

    public VehicleUpgradesMessage(FriendlyByteBuf buffer) {
        this.upgrades = new HashMap<Item, VehicleUpgrade>();
        int upgradeCount = buffer.readInt();
        for (int i = 0; i < upgradeCount; ++i) {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(buffer.m_130281_());
            this.upgrades.put(item, this.readUpgrade(buffer));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        Map<Item, VehicleUpgrade> upgrades = VehicleUpgradeRegistry.INSTANCE.getAll();
        buffer.writeInt(upgrades.size());
        for (Item item : upgrades.keySet()) {
            buffer.m_130085_(BuiltInRegistries.f_257033_.m_7981_((Object)item));
            this.writeUpgrade(buffer, upgrades.get(item));
        }
    }

    protected void writeUpgrade(FriendlyByteBuf buffer, VehicleUpgrade upgrade) {
        Map<VehicleStat, Float> upgradeMap = upgrade.getAll();
        buffer.writeInt(upgradeMap.size());
        for (VehicleStat stat : upgradeMap.keySet()) {
            buffer.m_130070_(stat.name());
            buffer.writeFloat(upgradeMap.get(stat).floatValue());
        }
    }

    protected VehicleUpgrade readUpgrade(FriendlyByteBuf buffer) {
        VehicleUpgrade upgrade = new VehicleUpgrade();
        int statCount = buffer.readInt();
        for (int j = 0; j < statCount; ++j) {
            upgrade.set(VehicleStat.STATS.get(buffer.m_130277_()), buffer.readFloat());
        }
        return upgrade;
    }

    @Override
    public void receive(Player player) {
        VehicleUpgradeRegistry.INSTANCE.replace(this.upgrades);
    }
}

