/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.item.upgrade;

import java.util.HashMap;
import java.util.Map;

public record VehicleStat(String name, boolean positive, float defaultValue) {
    public static final Map<String, VehicleStat> STATS = new HashMap<String, VehicleStat>();
    public static final VehicleStat ENGINE_SPEED = VehicleStat.register("engineSpeed", true);
    public static final VehicleStat VERTICAL_SPEED = VehicleStat.register("verticalSpeed", true);
    public static final VehicleStat YAW_SPEED = VehicleStat.register("yawSpeed", true);
    public static final VehicleStat PITCH_SPEED = VehicleStat.register("pitchSpeed", true);
    public static final VehicleStat PUSH_SPEED = VehicleStat.register("pushSpeed", true);
    public static final VehicleStat ACCELERATION = VehicleStat.register("acceleration", true, 1.0f);
    public static final VehicleStat DURABILITY = VehicleStat.register("durability", true, 1.0f);
    public static final VehicleStat FUEL = VehicleStat.register("fuel", false, 1.0f);
    public static final VehicleStat FRICTION = VehicleStat.register("friction", false, 0.015f);
    public static final VehicleStat GLIDE_FACTOR = VehicleStat.register("glideFactor", true);
    public static final VehicleStat LIFT = VehicleStat.register("lift", true);
    public static final VehicleStat ROLL_FACTOR = VehicleStat.register("rollFactor", true);
    public static final VehicleStat GROUND_PITCH = VehicleStat.register("groundPitch", true);
    public static final VehicleStat STABILIZER = VehicleStat.register("stabilizer", true, 0.0f);
    public static final VehicleStat WIND = VehicleStat.register("wind", false);
    public static final VehicleStat MASS = VehicleStat.register("mass", false, 1.0f);
    public static final VehicleStat GROUND_FRICTION = VehicleStat.register("groundFriction", false, 0.95f);
    public static final VehicleStat WATER_FRICTION = VehicleStat.register("waterFriction", false, 0.9f);
    public static final VehicleStat ROTATION_DECAY = VehicleStat.register("rotationDecay", false, 0.97f);
    public static final VehicleStat HORIZONTAL_DECAY = VehicleStat.register("horizontalDecay", false, 0.97f);
    public static final VehicleStat VERTICAL_DECAY = VehicleStat.register("verticalDecay", false, 0.97f);

    public static VehicleStat register(String name, boolean positive) {
        return VehicleStat.register(name, positive, 0.0f);
    }

    public static VehicleStat register(String name, boolean positive, float defaultValue) {
        VehicleStat stat = new VehicleStat(name, positive, defaultValue);
        STATS.put(name, stat);
        return stat;
    }
}

