/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.particle.client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.undying.alex_cave_addon.client.render.ModRenderType;
import net.undying.alex_cave_addon.entity.projectile.MagneticOrbEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class MagneticOrbParticle
extends Particle {
    @Nullable
    private final Entity owner;
    private final float[] color;
    @Nullable
    private Vec3 offset;
    @Nullable
    private Vec3 moveToPos;
    private final float size;
    private static final ParticleRenderType RENDER_TYPE = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager texture) {
        }

        public void m_6294_(Tesselator builder) {
        }
    };

    public MagneticOrbParticle(ClientLevel level, double x, double y, double z, int ownerId, int color, int lifetime) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.owner = ownerId >= 0 ? level.m_6815_(ownerId) : null;
        if (this.owner != null) {
            Vec3 center = this.owner.m_20191_().m_82399_();
            this.offset = new Vec3(x, y, z).m_82546_(center);
            this.moveToPos = center;
        }
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        this.color = rgb;
        this.f_107225_ = lifetime;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107219_ = false;
        this.size = 1.25f + (level.f_46441_.m_188501_() - 0.5f) * 0.1f;
    }

    public void m_5989_() {
        float f;
        ++this.f_107224_;
        Entity entity = this.owner;
        if (entity instanceof MagneticOrbEntity) {
            MagneticOrbEntity orb = (MagneticOrbEntity)entity;
            f = orb.getSize() * 3.0f;
        } else {
            f = 3.0f;
        }
        if (this.f_107224_ >= this.f_107225_ - (int)f) {
            this.m_107274_();
        } else {
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.updateMove(1.0f);
            this.f_107215_ *= (double)this.f_172258_;
            this.f_107216_ *= (double)this.f_172258_;
            this.f_107217_ *= (double)this.f_172258_;
        }
    }

    private void updateMove(float partialTick) {
        if (this.owner != null && this.owner.m_6084_()) {
            this.moveToPos = this.owner.m_20318_(partialTick).m_82520_(0.0, (double)(this.owner.m_20206_() / 2.0f), 0.0);
        }
        if (this.moveToPos != null && this.offset != null) {
            this.f_107212_ = this.moveToPos.f_82479_ + this.offset.f_82479_;
            this.f_107213_ = this.moveToPos.f_82480_ + this.offset.f_82480_;
            this.f_107214_ = this.moveToPos.f_82481_ + this.offset.f_82481_;
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
        }
    }

    private float getMoveProgress(float partialTick) {
        float f = ((float)this.f_107224_ + partialTick) / (float)this.f_107225_;
        return (MagneticOrbParticle.ease(f) * 2.0f + f) / 3.0f;
    }

    private static float ease(float f) {
        return (float)(1.0 - Math.cos((double)f * Math.PI / 2.0));
    }

    public ParticleRenderType m_7556_() {
        return RENDER_TYPE;
    }

    public void m_5744_(VertexConsumer builder, Camera camera, float partialTick) {
        this.updateMove(partialTick);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        builder = buffer.m_6299_(ModRenderType.getEntityLightning());
        PoseStack poseStack = new PoseStack();
        Vec3 vec = camera.m_90583_();
        float f = this.getMoveProgress(partialTick);
        poseStack.m_85836_();
        poseStack.m_85837_(-vec.f_82479_, -vec.f_82480_, -vec.f_82481_);
        double posX = Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_);
        double posY = Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_);
        double posZ = Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_);
        if (this.moveToPos != null) {
            posX = Mth.m_14139_((double)f, (double)posX, (double)this.moveToPos.f_82479_);
            posY = Mth.m_14139_((double)f, (double)posY, (double)this.moveToPos.f_82480_);
            posZ = Mth.m_14139_((double)f, (double)posZ, (double)this.moveToPos.f_82481_);
        }
        poseStack.m_85837_(posX, posY, posZ);
        this.drawSquare(poseStack, builder, partialTick);
        poseStack.m_85849_();
        buffer.m_109911_();
    }

    private void drawSquare(PoseStack poseStack, VertexConsumer builder, float partialTick) {
        poseStack.m_85836_();
        Quaternionf quat = Minecraft.m_91087_().f_91063_.m_109153_().m_253121_();
        poseStack.m_252781_(quat);
        float f = this.getSize(partialTick) / 16.0f;
        poseStack.m_85841_(f, f, f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        this.drawVertex(matrix, normal, builder, -0.5f, -0.5f);
        this.drawVertex(matrix, normal, builder, -0.5f, 0.5f);
        this.drawVertex(matrix, normal, builder, 0.5f, 0.5f);
        this.drawVertex(matrix, normal, builder, 0.5f, -0.5f);
        poseStack.m_85849_();
    }

    private float getSize(float partialTick) {
        float f = Mth.m_14036_((float)((float)this.f_107224_ + partialTick), (float)0.0f, (float)1.0f);
        return this.size * this.getMoveProgress(partialTick) * f;
    }

    private void drawVertex(Matrix4f matrix, Matrix3f normal, VertexConsumer builder, float x, float y) {
        builder.m_252986_(matrix, x, y, 0.01f).m_85950_(this.color[0], this.color[1], this.color[2], 0.99f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double ownerId, double color, double lifetime) {
            return new MagneticOrbParticle(level, x, y, z, Mth.m_14107_((double)ownerId), Mth.m_14107_((double)color), Mth.m_14107_((double)lifetime));
        }
    }
}

