/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.undying.alex_cave_addon.client.animation.PlayerKeyframeAnimations;
import net.undying.alex_cave_addon.entity.ability.PlayerAccess;
import net.undying.alex_cave_addon.entity.ability.Skill;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> model, float shadow) {
        super(context, model, shadow);
    }

    @Inject(at={@At(value="RETURN")}, method={"setupRotations"})
    private void rotatePlayer(AbstractClientPlayer player, PoseStack poseStack, float ageInTicks, float bodyRot, float partialTick, CallbackInfo info) {
        AnimationDefinition anim;
        Skill skill = Skill.fromId(PlayerAccess.getClientSkillId((Player)player));
        if (skill != null && (anim = skill.data.getAnimation((Player)player)) != null) {
            boolean mirror = player.m_5737_() == HumanoidArm.LEFT;
            String part = "root";
            long time = (long)(((float)skill.duration - ((float)(PlayerAccess.getClientSkillTicks((Player)player) + 1) - partialTick)) * 50.0f);
            Vector3f vec = PlayerKeyframeAnimations.getAnimValue(anim, part, PlayerKeyframeAnimations.TransformType.POSITION, time, 1.0f);
            vec.mul(0.0625f);
            if (mirror) {
                vec.mul(-1.0f, 1.0f, 1.0f);
            }
            poseStack.m_252880_(-vec.x, -vec.y, vec.z);
            vec = PlayerKeyframeAnimations.getAnimValue(anim, part, PlayerKeyframeAnimations.TransformType.ROTATION, time, 1.0f);
            if (mirror) {
                vec.mul(1.0f, -1.0f, -1.0f);
            }
            poseStack.m_252781_(new Quaternionf().rotateZYX(vec.z, -vec.y, -vec.x));
            vec = PlayerKeyframeAnimations.getAnimValue(anim, part, PlayerKeyframeAnimations.TransformType.SCALE, time, 1.0f);
            vec.add(1.0f, 1.0f, 1.0f);
            poseStack.m_85841_(vec.x, vec.y, vec.z);
        }
    }
}

