/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.mixin;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.QuarryBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.QuarrySmasherEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.QuarrySmasherHeadEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.undying.alex_cave_addon.Config;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={QuarrySmasherEntity.class}, priority=500)
public abstract class QuarrySmasherEntityMixin
extends Entity {
    @Shadow(remap=false)
    @Final
    private QuarrySmasherHeadEntity headPart;
    @Shadow(remap=false)
    private int blockBreakCooldown;
    @Shadow(remap=false)
    private AABB lastMiningArea;

    QuarrySmasherEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"tickMultipart"}, remap=false, cancellable=true)
    private void tickMultipart(CallbackInfo info) {
        if (((Boolean)Config.COMMON.COOLER_MAGNETIC_QUARRY.get()).booleanValue()) {
            info.cancel();
            Vec3 headTarget = this.getHeadTargetPos();
            float fallSpeed = 1.0f;
            if (this.isInactive()) {
                fallSpeed = 0.5f;
            } else if (!this.isSlamming() && this.pullingItemsFor() > 5) {
                fallSpeed = 0.0f;
            }
            Vec3 moveHeadBy = headTarget.m_82546_(this.headPart.m_20182_()).m_82490_((double)fallSpeed);
            if (this.f_19797_ > 1) {
                this.headPart.m_146867_();
                this.headPart.m_146884_(moveHeadBy.m_82549_(this.headPart.m_20182_()));
            } else {
                this.headPart.m_146884_(this.m_20182_());
                this.headPart.m_146867_();
            }
        }
    }

    @ModifyExpressionValue(at={@At(value="INVOKE", target="Lcom/github/alexmodguy/alexscaves/server/entity/item/QuarrySmasherEntity;isInactive()Z", remap=false, ordinal=2)}, method={"tick"})
    private boolean redirectTick(boolean original) {
        return original || (Boolean)Config.COMMON.COOLER_MAGNETIC_QUARRY.get() != false;
    }

    @ModifyExpressionValue(at={@At(value="INVOKE", target="Lcom/github/alexmodguy/alexscaves/server/entity/item/QuarrySmasherEntity;isNoGravity()Z", ordinal=0)}, method={"tick"})
    private boolean redirectTick2(boolean original) {
        this.tickCustom();
        return original || (Boolean)Config.COMMON.COOLER_MAGNETIC_QUARRY.get() != false;
    }

    @Unique
    private void tickCustom() {
        if (this.isInactive()) {
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.2, 0.0));
            }
        } else {
            BlockPos quarryPos = this.getQuarryPos();
            if (quarryPos != null && this.m_9236_().m_8055_(quarryPos).m_60713_((Block)ACBlockRegistry.QUARRY.get())) {
                BlockEntity var12 = this.m_9236_().m_7702_(quarryPos);
                if (var12 instanceof QuarryBlockEntity) {
                    QuarryBlockEntity quarryBlockEntity = (QuarryBlockEntity)var12;
                    this.lastMiningArea = quarryBlockEntity.getMiningBox();
                }
            } else {
                this.setQuarryPos(null);
                this.setInactive(true);
            }
            BlockPos quarry = this.getTargetPos();
            if (!this.m_9236_().f_46443_) {
                if (quarry == null) {
                    this.setTargetPos(this.findTarget());
                } else {
                    Vec3 dist = Vec3.m_82514_((Vec3i)(quarryPos == null ? quarry : quarry.m_175288_(quarryPos.m_123342_())), (double)4.0).m_82546_(this.m_20182_());
                    this.m_146884_(this.m_20182_().m_82549_(dist));
                    if (this.blockBreakCooldown <= 0) {
                        this.setSlamming(true);
                        if (this.headPart.m_20182_().m_82554_(Vec3.m_82539_((Vec3i)quarry)) < 1.1) {
                            this.setSlamming(false);
                            this.m_9236_().m_5594_(null, quarry, (SoundEvent)ACSoundRegistry.BOUNDROID_SLAM.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
                            this.m_9236_().m_46961_(quarry, true);
                            this.setTargetPos(null);
                            this.blockBreakCooldown = 1;
                            this.setPullingItemsFor(2);
                        }
                    }
                }
            }
        }
    }

    @ModifyExpressionValue(at={@At(value="INVOKE", target="Lcom/github/alexmodguy/alexscaves/server/entity/item/QuarrySmasherEntity;isRemoved()Z", ordinal=0)}, method={"hurt"})
    private boolean redirectDropItem(boolean original, DamageSource source, float damage) {
        LivingEntity living;
        Entity entity;
        if (((Boolean)Config.COMMON.COOLER_MAGNETIC_QUARRY.get()).booleanValue() && (entity = source.m_7640_()) instanceof LivingEntity && EnchantmentHelper.m_272262_((ItemStack)(living = (LivingEntity)entity).m_21205_())) {
            this.m_19998_((ItemLike)ACItemRegistry.QUARRY_SMASHER.get());
            return true;
        }
        return original;
    }

    @Shadow(remap=false)
    protected abstract Vec3 getHeadTargetPos();

    @Shadow(remap=false)
    protected abstract boolean isInactive();

    @Shadow(remap=false)
    protected abstract boolean isSlamming();

    @Shadow(remap=false)
    protected abstract void setSlamming(boolean var1);

    @Shadow(remap=false)
    protected abstract int pullingItemsFor();

    @Shadow(remap=false)
    @Nullable
    protected abstract BlockPos getQuarryPos();

    @Shadow(remap=false)
    @Nullable
    protected abstract BlockPos getTargetPos();

    @Shadow(remap=false)
    protected abstract BlockPos findTarget();

    @Shadow(remap=false)
    protected abstract void setQuarryPos(@Nullable BlockPos var1);

    @Shadow(remap=false)
    protected abstract void setTargetPos(@Nullable BlockPos var1);

    @Shadow(remap=false)
    protected abstract void setInactive(boolean var1);

    @Shadow(remap=false)
    protected abstract void setPullingItemsFor(int var1);
}

