/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.mixin;

import com.github.alexmodguy.alexscaves.server.block.blockentity.QuarryBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.QuarrySmasherEntity;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.undying.alex_cave_addon.Config;
import net.undying.alex_cave_addon.entity.IQuarryBlock;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={QuarryBlockEntity.class})
public class QuarryBlockEntityMixin
implements IQuarryBlock {
    @Unique
    private List<QuarrySmasherEntity> entities = new ArrayList<QuarrySmasherEntity>();
    @Shadow(remap=false)
    @Nullable
    private BlockPos lastMineablePos;
    @Shadow(remap=false)
    @Nullable
    private QuarrySmasherEntity serverSmasher;
    @Shadow(remap=false)
    private boolean hasMiningArea;
    @Shadow(remap=false)
    private AABB miningBox;

    @Inject(at={@At(value="HEAD")}, method={"tick"}, remap=false)
    private static void customPutSmasher(Level level, BlockPos blockPos, BlockState state, QuarryBlockEntity entity, CallbackInfo info) {
        List<QuarrySmasherEntity> list = ((IQuarryBlock)entity).alexcaveaddon_getEntities();
        if (((Boolean)Config.COMMON.COOLER_MAGNETIC_QUARRY.get()).booleanValue()) {
            QuarrySmasherEntity smasher = ((IQuarryBlock)entity).alexcaveaddon_serverSmasher();
            if (smasher != null && !list.contains(smasher)) {
                list.add(smasher);
            }
            ((IQuarryBlock)entity).alexcaveaddon_setServerSmasher(null);
        } else {
            if (!list.isEmpty() && list.get(0) != null) {
                ((IQuarryBlock)entity).alexcaveaddon_setServerSmasher(list.get(0));
            }
            list.clear();
        }
    }

    @WrapOperation(at={@At(value="FIELD", target="Lcom/github/alexmodguy/alexscaves/server/block/blockentity/QuarryBlockEntity;serverSmasher:Lcom/github/alexmodguy/alexscaves/server/entity/item/QuarrySmasherEntity;", remap=false, ordinal=0, opcode=181)}, method={"tick"}, remap=false)
    private static void redirectPutSmasher(QuarryBlockEntity block, QuarrySmasherEntity original, Operation<QuarrySmasherEntity> original1) {
        if (((Boolean)Config.COMMON.COOLER_MAGNETIC_QUARRY.get()).booleanValue()) {
            List<QuarrySmasherEntity> list = ((IQuarryBlock)block).alexcaveaddon_getEntities();
            if (!list.contains(original)) {
                list.add(original);
            }
            original1.call(new Object[]{block, null});
        } else {
            original1.call(new Object[]{block, original});
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"}, remap=false)
    private static void tickPutSmasher(Level level, BlockPos blockPos, BlockState state, QuarryBlockEntity entity, CallbackInfo info) {
        if (((Boolean)Config.COMMON.COOLER_MAGNETIC_QUARRY.get()).booleanValue()) {
            List<QuarrySmasherEntity> entities = ((IQuarryBlock)entity).alexcaveaddon_getEntities();
            entities.removeIf(Objects::isNull);
            if (!entities.isEmpty()) {
                ArrayList<QuarrySmasherEntity> entities1 = new ArrayList<QuarrySmasherEntity>(entities);
                for (QuarrySmasherEntity entity1 : entities1) {
                    entity1.setQuarryPos(blockPos);
                    if (entity1.m_213877_()) {
                        entities.remove(entity1);
                        continue;
                    }
                    if (((IQuarryBlock)entity).alexcaveaddon_hasMiningArea() && ((IQuarryBlock)entity).alexcaveaddon_lastMineablePos() != null) {
                        entity1.setInactive(false);
                        continue;
                    }
                    entity1.setInactive(true);
                    entities.remove(entity1);
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"findMinableBlock"}, remap=false, cancellable=true)
    private void customFindBlock(Level level, double yStart, CallbackInfoReturnable<Optional<BlockPos>> info) {
        if (((Boolean)Config.COMMON.COOLER_MAGNETIC_QUARRY.get()).booleanValue()) {
            info.cancel();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            BlockPos highest = null;
            for (int x = (int)(this.miningBox.f_82288_ + 1.0); x < (int)this.miningBox.f_82291_; ++x) {
                for (int z = (int)(this.miningBox.f_82290_ + 1.0); z < (int)this.miningBox.f_82293_; ++z) {
                    mutableBlockPos.m_122169_((double)x, yStart, (double)z);
                    while (mutableBlockPos.m_123342_() > level.m_141937_() + 1 && !this.customFindBlock(level, (BlockPos)mutableBlockPos)) {
                        mutableBlockPos.m_122184_(0, -1, 0);
                    }
                    if (!this.customFindBlock(level, (BlockPos)mutableBlockPos) || highest != null && highest.m_123342_() >= mutableBlockPos.m_123342_()) continue;
                    highest = mutableBlockPos.m_7949_();
                }
            }
            info.setReturnValue(Optional.ofNullable(highest));
        }
    }

    @Unique
    private boolean customFindBlock(Level level, BlockPos pos) {
        boolean original = QuarryBlockEntity.isMinable((Level)level, (BlockPos)pos);
        if (original) {
            for (QuarrySmasherEntity entity : this.entities) {
                if (entity == null || !Objects.equals(entity.getTargetPos(), pos)) continue;
                return false;
            }
        }
        return original;
    }

    @ModifyExpressionValue(at={@At(value="FIELD", target="Lcom/github/alexmodguy/alexscaves/server/block/blockentity/QuarryBlockEntity;FURTHEST_TORCH_DISTANCE:I", remap=false, opcode=178)}, method={"searchForTorches"}, remap=false)
    private int expandMiningArea(int original) {
        return (Boolean)Config.COMMON.COOLER_MAGNETIC_QUARRY.get() != false ? original * 3 : original;
    }

    @Unique
    private static void findSmashersCustom(Level level, BlockPos blockPos, BlockState state, QuarryBlockEntity entity) {
        if (!level.f_46443_) {
            ((IQuarryBlock)entity).alexcaveaddon_setLastMineablePos(entity.findMinableBlock(level, (double)(blockPos.m_123342_() + 3)).orElse(null));
            for (QuarrySmasherEntity entity12 : level.m_6443_(QuarrySmasherEntity.class, ((IQuarryBlock)entity).alexcaveaddon_getMiningBox().m_82377_(0.1, 128.0, 0.1), entity1 -> entity1.getQuarryPos() == null)) {
                List<QuarrySmasherEntity> list = ((IQuarryBlock)entity).alexcaveaddon_getEntities();
                if (list.contains(entity12)) continue;
                list.add(entity12);
            }
        }
    }

    @Override
    public List<QuarrySmasherEntity> alexcaveaddon_getEntities() {
        return this.entities;
    }

    @Override
    @Nullable
    public BlockPos alexcaveaddon_lastMineablePos() {
        return this.lastMineablePos;
    }

    @Override
    public void alexcaveaddon_setLastMineablePos(@Nullable BlockPos pos) {
        this.lastMineablePos = pos;
    }

    @Override
    public boolean alexcaveaddon_hasMiningArea() {
        return this.hasMiningArea;
    }

    @Override
    public AABB alexcaveaddon_getMiningBox() {
        return this.miningBox;
    }

    @Override
    @Nullable
    public QuarrySmasherEntity alexcaveaddon_serverSmasher() {
        return this.serverSmasher;
    }

    @Override
    public void alexcaveaddon_setServerSmasher(@Nullable QuarrySmasherEntity entity) {
        this.serverSmasher = entity;
    }
}

