/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.mixin;

import com.github.alexmodguy.alexscaves.server.entity.living.LuxtructosaurusEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.SauropodBaseEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.undying.alex_cave_addon.Config;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LuxtructosaurusEntity.class})
public abstract class LuxtructosaurusEntityMixin
extends SauropodBaseEntity {
    LuxtructosaurusEntityMixin(EntityType entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"burnWithBreath"}, remap=false, cancellable=true)
    private void noBreak2(float maxDistance, CallbackInfo info) {
        info.cancel();
        float burnWidth = 1.0f;
        Vec3 headPos = this.headPart.centeredPosition();
        float burnAngle = this.f_20883_ + this.neckYRot;
        for (float distanceBurned = 0.0f; distanceBurned < maxDistance; distanceBurned += burnWidth) {
            burnWidth += 1.0f;
            Vec3 burnPos = headPos.m_82549_(this.rotateOffsetVec(new Vec3(0.0, 0.0, (double)distanceBurned), 0.0f, burnAngle));
            if (this.f_19796_.m_188501_() < 0.5f * (1.0f - (maxDistance - distanceBurned) / maxDistance)) {
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                pos.m_122169_(burnPos.f_82479_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 2.0f * distanceBurned), burnPos.f_82480_, burnPos.f_82481_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 2.0f * distanceBurned));
                while (this.canFissureMoveThrough(pos)) {
                    pos.m_122184_(0, -1, 0);
                }
                pos.m_122184_(0, 1, 0);
                if (this.m_9236_().m_8055_((BlockPos)pos).m_247087_()) {
                    this.m_9236_().m_46597_((BlockPos)pos, Blocks.f_50083_.m_49966_());
                }
            }
            this.hurtEntitiesAround(burnPos, burnWidth, 3.0f, 0.3f, true, false);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(D)Lnet/minecraft/world/phys/AABB;")}, method={"aiStep"}, cancellable=true)
    private void noBreak4(CallbackInfo info) {
        if (!this.isAddedToWorld() || !ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    private void noDamageModifier1(DamageSource source, float damage, CallbackInfoReturnable<Boolean> info) {
        if (((Boolean)Config.COMMON.LUX_NO_DAMAGE_MODIFIER.get()).booleanValue()) {
            info.cancel();
            info.setReturnValue((Object)super.m_6469_(source, damage));
        }
    }

    @Shadow(remap=false)
    protected abstract boolean canFissureMoveThrough(BlockPos.MutableBlockPos var1);
}

